/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.TlsCipherPreference;
import software.amazon.awssdk.crt.utils.PemUtils;

public final class TlsContextOptions
extends CrtResource {
    public TlsVersions minTlsVersion = TlsVersions.TLS_VER_SYS_DEFAULTS;
    public TlsCipherPreference tlsCipherPreference = TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT;
    public List<String> alpnList = new ArrayList<String>();
    public boolean verifyPeer = false;
    private String certificate;
    private String privateKey;
    private String certificatePath;
    private String privateKeyPath;
    private String caRoot;
    private String caFile;
    private String caDir;
    private String pkcs12Path;
    private String pkcs12Password;

    private TlsContextOptions() {
    }

    @Override
    public long getNativeHandle() {
        if (super.getNativeHandle() == 0L) {
            if (this.tlsCipherPreference != TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT && this.minTlsVersion != TlsVersions.TLS_VER_SYS_DEFAULTS) {
                throw new IllegalStateException("tlsCipherPreference and minTlsVersion are mutually exclusive");
            }
            this.acquireNativeHandle(TlsContextOptions.tlsContextOptionsNew(this.minTlsVersion.getValue(), this.tlsCipherPreference.getValue(), this.alpnList.size() > 0 ? String.join((CharSequence)";", this.alpnList) : null, this.certificate, this.privateKey, this.certificatePath, this.privateKeyPath, this.caRoot, this.caFile, this.caDir, this.verifyPeer, this.pkcs12Path, this.pkcs12Password));
        }
        return super.getNativeHandle();
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            TlsContextOptions.tlsContextOptionsDestroy(this.getNativeHandle());
        }
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            super.close();
        }
    }

    public void setCipherPreference(TlsCipherPreference cipherPref) {
        if (!TlsContextOptions.isCipherPreferenceSupported(cipherPref)) {
            throw new IllegalArgumentException("TlsCipherPreference is not supported on this platform: " + cipherPref.name());
        }
        if (this.minTlsVersion != TlsVersions.TLS_VER_SYS_DEFAULTS && cipherPref != TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT) {
            throw new IllegalArgumentException("Currently only setMinimumTlsVersion() or setCipherPreference() may be used, not both.");
        }
        this.tlsCipherPreference = cipherPref;
    }

    public void initMtlsFromPath(String certificatePath, String privateKeyPath) {
        this.certificatePath = certificatePath;
        this.privateKeyPath = privateKeyPath;
    }

    public void initMtls(String certificate, String privateKey) throws IllegalArgumentException {
        this.certificate = PemUtils.cleanUpPem(certificate);
        PemUtils.sanityCheck(certificate, 1, "CERTIFICATE");
        this.privateKey = PemUtils.cleanUpPem(privateKey);
        PemUtils.sanityCheck(privateKey, 1, "PRIVATE KEY");
    }

    public void initMtlsPkcs12(String pkcs12Path, String pkcs12Password) {
        if (this.certificate != null || this.privateKey != null || this.certificatePath != null || this.privateKeyPath != null) {
            throw new IllegalArgumentException("PKCS#12 and MTLS via certificate/private key pair are mutually exclusive");
        }
        this.pkcs12Path = pkcs12Path;
        this.pkcs12Password = pkcs12Password;
    }

    public static boolean isAlpnSupported() {
        return TlsContextOptions.tlsContextOptionsIsAlpnAvailable();
    }

    public static boolean isCipherPreferenceSupported(TlsCipherPreference cipherPref) {
        return TlsContextOptions.tlsContextOptionsIsCipherPreferenceSupported(cipherPref.getValue());
    }

    public void overrideDefaultTrustStoreFromPath(String caPath, String caFile) {
        if (this.caRoot != null) {
            throw new IllegalArgumentException("Certificate authority is already specified via PEM buffer");
        }
        this.caDir = caPath;
        this.caFile = caFile;
    }

    public void overrideDefaultTrustStore(String caRoot) throws IllegalArgumentException {
        if (this.caFile != null || this.caDir != null) {
            throw new IllegalArgumentException("Certificate authority is already specified via path(s)");
        }
        this.caRoot = PemUtils.cleanUpPem(caRoot);
        PemUtils.sanityCheck(this.caRoot, 7, "CERTIFICATE");
    }

    public static TlsContextOptions createDefaultClient() {
        TlsContextOptions options = new TlsContextOptions();
        options.verifyPeer = true;
        return options;
    }

    public static TlsContextOptions createDefaultServer() {
        TlsContextOptions options = new TlsContextOptions();
        options.verifyPeer = false;
        return options;
    }

    public static TlsContextOptions createWithMtlsFromPath(String certificatePath, String privateKeyPath) {
        TlsContextOptions options = new TlsContextOptions();
        options.initMtlsFromPath(certificatePath, privateKeyPath);
        options.verifyPeer = true;
        return options;
    }

    public static TlsContextOptions createWithMtls(String certificate, String privateKey) throws IllegalArgumentException {
        TlsContextOptions options = new TlsContextOptions();
        options.initMtls(certificate, privateKey);
        options.verifyPeer = true;
        return options;
    }

    public static TlsContextOptions createWithMtlsPkcs12(String pkcs12Path, String pkcs12Password) {
        TlsContextOptions options = new TlsContextOptions();
        options.initMtlsPkcs12(pkcs12Path, pkcs12Password);
        options.verifyPeer = true;
        return options;
    }

    public TlsContextOptions withCipherPreference(TlsCipherPreference cipherPref) {
        this.setCipherPreference(cipherPref);
        return this;
    }

    public TlsContextOptions withMinimumTlsVersion(TlsVersions version) {
        this.minTlsVersion = version;
        return this;
    }

    public TlsContextOptions withAlpnList(String alpnList) {
        String[] parts;
        for (String part : parts = alpnList.split(";")) {
            this.alpnList.add(part);
        }
        return this;
    }

    public TlsContextOptions withMtls(String certificate, String privateKey) {
        this.initMtls(certificate, privateKey);
        return this;
    }

    public TlsContextOptions withMtlsFromPath(String certificatePath, String privateKeyPath) {
        this.initMtlsFromPath(certificatePath, privateKeyPath);
        return this;
    }

    public TlsContextOptions withCertificateAuthority(String caRoot) {
        this.overrideDefaultTrustStore(caRoot);
        return this;
    }

    public TlsContextOptions withCertificateAuthorityFromPath(String caDirPath, String caFilePath) {
        this.overrideDefaultTrustStoreFromPath(caDirPath, caFilePath);
        return this;
    }

    public TlsContextOptions withMtlsPkcs12(String pkcs12Path, String pkcs12Password) {
        this.initMtlsPkcs12(pkcs12Path, pkcs12Password);
        return this;
    }

    public TlsContextOptions withVerifyPeer(boolean verify) {
        this.verifyPeer = verify;
        return this;
    }

    public TlsContextOptions withVerifyPeer() {
        return this.withVerifyPeer(true);
    }

    private static native long tlsContextOptionsNew(int var0, int var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, boolean var10, String var11, String var12);

    private static native void tlsContextOptionsDestroy(long var0);

    private static native boolean tlsContextOptionsIsAlpnAvailable();

    private static native boolean tlsContextOptionsIsCipherPreferenceSupported(int var0);

    public static enum TlsVersions {
        SSLv3(0),
        TLSv1(1),
        TLSv1_1(2),
        TLSv1_2(3),
        TLSv1_3(4),
        TLS_VER_SYS_DEFAULTS(128);

        private int version;

        private TlsVersions(int val) {
            this.version = val;
        }

        int getValue() {
            return this.version;
        }
    }
}

