/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.Log;

public abstract class CrtResource
implements AutoCloseable {
    private static final String NATIVE_DEBUG_PROPERTY_NAME = "aws.crt.debugnative";
    private static final long DEBUG_CLEANUP_WAIT_TIME_IN_SECONDS = 30L;
    private static final long NULL = 0L;
    private static final ConcurrentHashMap<Long, String> NATIVE_RESOURCES = new ConcurrentHashMap();
    private static boolean debugNativeObjects = System.getProperty("aws.crt.debugnative") != null;
    private static int resourceCount = 0;
    private static final Lock lock = new ReentrantLock();
    private static final Condition emptyResources = lock.newCondition();
    private final LinkedList<CrtResource> referencedResources = new LinkedList();
    private long nativeHandle;
    private AtomicInteger refCount = new AtomicInteger(1);

    public <T extends CrtResource> T addReferenceTo(T resource) {
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s is adding a reference to instance of class %s", this.getClass().getCanonicalName(), resource.getClass().getCanonicalName()));
        }
        resource.addRef();
        this.referencedResources.push(resource);
        return resource;
    }

    protected void acquireNativeHandle(long handle) {
        if (!this.isNull()) {
            throw new IllegalStateException("Can't acquire >1 Native Pointer");
        }
        if (!this.isNativeResource()) {
            throw new IllegalStateException("Non-native resources cannot acquire a native pointer");
        }
        String canonicalName = this.getClass().getCanonicalName();
        if (handle == 0L) {
            throw new IllegalStateException("Can't acquire NULL Pointer: " + canonicalName);
        }
        String lastValue = NATIVE_RESOURCES.put(handle, canonicalName);
        if (lastValue != null) {
            throw new IllegalStateException("Acquired two CrtResources to the same Native Resource! Class: " + lastValue);
        }
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("acquireNativeHandle - %s acquired native pointer %d", canonicalName, handle));
        }
        this.nativeHandle = handle;
        CrtResource.incrementNativeObjectCount();
    }

    private void release() {
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Releasing class %s", this.getClass().getCanonicalName()));
        }
        if (this.isNativeResource()) {
            if (this.isNull()) {
                throw new IllegalStateException("Already Released Resource!");
            }
            NATIVE_RESOURCES.remove(this.nativeHandle);
        }
        this.releaseNativeHandle();
        if (this.isNativeResource()) {
            CrtResource.decrementNativeObjectCount();
            this.nativeHandle = 0L;
        }
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    void addRef() {
        this.refCount.incrementAndGet();
    }

    protected abstract void releaseNativeHandle();

    protected abstract boolean canReleaseReferencesImmediately();

    public boolean isNull() {
        return this.nativeHandle == 0L;
    }

    protected boolean isNativeResource() {
        return true;
    }

    @Override
    public void close() {
        int remainingRefs = this.refCount.decrementAndGet();
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Closing instance of class %s with %d remaining refs", this.getClass().getCanonicalName(), remainingRefs));
        }
        if (remainingRefs > 0) {
            return;
        }
        this.release();
        if (this.canReleaseReferencesImmediately()) {
            this.releaseReferences();
        }
    }

    protected void releaseReferences() {
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s closing referenced objects", this.getClass().getCanonicalName()));
        }
        while (this.referencedResources.size() > 0) {
            CrtResource r = this.referencedResources.pop();
            r.close();
        }
    }

    public static void collectNativeResources(Consumer<String> fn) {
        for (Map.Entry<Long, String> entry : NATIVE_RESOURCES.entrySet()) {
            String resource = String.format(" * %s class instance using native pointer %d", entry.getValue(), (long)entry.getKey());
            fn.accept(resource);
        }
    }

    public static void logNativeResources() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, "Dumping native object set:");
        CrtResource.collectNativeResources(resource -> Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, resource));
    }

    private static void incrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("incrementNativeObjectCount - count = %d", ++resourceCount));
        }
        finally {
            lock.unlock();
        }
    }

    private static void decrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("decrementNativeObjectCount - count = %d", --resourceCount));
            if (resourceCount == 0) {
                emptyResources.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void waitForNoResources() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            long timeout = System.currentTimeMillis() + 30000L;
            while (resourceCount != 0 && System.currentTimeMillis() < timeout) {
                emptyResources.await(1L, TimeUnit.SECONDS);
            }
            if (resourceCount != 0) {
                Log.log(Log.LogLevel.Error, Log.LogSubject.JavaCrtResource, "waitForNoResources - timeOut");
                CrtResource.logNativeResources();
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Timeout waiting for resource count to drop to zero");
        }
        finally {
            lock.unlock();
        }
    }

    static {
        new CRT();
    }
}

