/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;

public final class EventLoopGroup
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public EventLoopGroup(int numThreads) throws CrtRuntimeException {
        this.acquireNativeHandle(EventLoopGroup.eventLoopGroupNew(numThreads));
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            EventLoopGroup.eventLoopGroupDestroy(this, this.getNativeHandle());
        }
    }

    private void onCleanupComplete() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.IoEventLoop, "EventLoopGroup.onCleanupComplete");
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long eventLoopGroupNew(int var0) throws CrtRuntimeException;

    private static native void eventLoopGroupDestroy(EventLoopGroup var0, long var1);
}

