/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.Log;

public abstract class CrtResource
implements AutoCloseable {
    private static final String NATIVE_DEBUG_PROPERTY_NAME = "aws.crt.debugnative";
    private static final long DEBUG_CLEANUP_WAIT_TIME_IN_SECONDS = 10L;
    private static final long NULL = 0L;
    private static final ConcurrentHashMap<Long, ResourceInstance> NATIVE_RESOURCES = new ConcurrentHashMap();
    private static boolean debugNativeObjects = System.getProperty("aws.crt.debugnative") != null;
    private static int resourceCount = 0;
    private static final Lock lock = new ReentrantLock();
    private static final Condition emptyResources = lock.newCondition();
    private static final AtomicLong nextId = new AtomicLong(0L);
    private final ArrayList<CrtResource> referencedResources = new ArrayList();
    private long nativeHandle;
    private AtomicInteger refCount = new AtomicInteger(1);
    private long id = nextId.getAndAdd(1L);
    private Instant creationTime = Instant.now();
    private String description;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferenceTo(CrtResource resource) {
        resource.addRef();
        CrtResource crtResource = this;
        synchronized (crtResource) {
            this.referencedResources.add(resource);
        }
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s is adding a reference to instance of class %s", this.getClass().getCanonicalName(), resource.getClass().getCanonicalName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferenceTo(CrtResource resource) {
        boolean removed = false;
        CrtResource crtResource = this;
        synchronized (crtResource) {
            removed = this.referencedResources.remove(resource);
        }
        if (debugNativeObjects) {
            if (removed) {
                Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s is removing a reference to instance of class %s", this.getClass().getCanonicalName(), resource.getClass().getCanonicalName()));
            } else {
                Log.log(Log.LogLevel.Debug, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s erroneously tried to remove a reference to instance of class %s that it was not referencing", this.getClass().getCanonicalName(), resource.getClass().getCanonicalName()));
            }
        }
        if (!removed) {
            return;
        }
        resource.decRef();
    }

    protected void swapReferenceTo(CrtResource oldReference, CrtResource newReference) {
        if (oldReference != newReference) {
            if (newReference != null) {
                this.addReferenceTo(newReference);
            }
            if (oldReference != null) {
                this.removeReferenceTo(oldReference);
            }
        }
    }

    protected void acquireNativeHandle(long handle) {
        if (!this.isNull()) {
            throw new IllegalStateException("Can't acquire >1 Native Pointer");
        }
        String canonicalName = this.getClass().getCanonicalName();
        if (handle == 0L) {
            throw new IllegalStateException("Can't acquire NULL Pointer: " + canonicalName);
        }
        ResourceInstance lastValue = NATIVE_RESOURCES.put(handle, new ResourceInstance(this, handle, canonicalName));
        if (lastValue != null) {
            throw new IllegalStateException("Acquired two CrtResources to the same Native Resource! Class: " + lastValue);
        }
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("acquireNativeHandle - %s acquired native pointer %d", canonicalName, handle));
        }
        this.nativeHandle = handle;
        CrtResource.incrementNativeObjectCount();
    }

    private void release() {
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Releasing class %s", this.getClass().getCanonicalName()));
        }
        if (this.nativeHandle != 0L) {
            NATIVE_RESOURCES.remove(this.nativeHandle);
        }
        this.releaseNativeHandle();
        if (this.nativeHandle != 0L) {
            CrtResource.decrementNativeObjectCount();
            this.nativeHandle = 0L;
        }
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    public void addRef() {
        this.refCount.incrementAndGet();
    }

    protected abstract void releaseNativeHandle();

    protected abstract boolean canReleaseReferencesImmediately();

    public boolean isNull() {
        return this.nativeHandle == 0L;
    }

    @Override
    public void close() {
        this.decRef();
    }

    protected void decRef() {
        int remainingRefs = this.refCount.decrementAndGet();
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Closing instance of class %s with %d remaining refs", this.getClass().getCanonicalName(), remainingRefs));
        }
        if (remainingRefs != 0) {
            return;
        }
        this.release();
        if (this.canReleaseReferencesImmediately()) {
            this.releaseReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReferences() {
        if (debugNativeObjects) {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("Instance of class %s closing referenced objects", this.getClass().getCanonicalName()));
        }
        CrtResource crtResource = this;
        synchronized (crtResource) {
            for (CrtResource resource : this.referencedResources) {
                resource.decRef();
            }
            this.referencedResources.clear();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceLogDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("[Id %d, Class %s, Refs %d](%s) - %s", this.id, this.getClass().getSimpleName(), this.refCount.get(), this.creationTime.toString(), this.description != null ? this.description : "<null>"));
        CrtResource crtResource = this;
        synchronized (crtResource) {
            if (this.referencedResources.size() > 0) {
                builder.append("\n   Forward references by Id: ");
                for (CrtResource reference : this.referencedResources) {
                    builder.append(String.format("%d", reference.id));
                }
            }
        }
        return builder.toString();
    }

    public static void collectNativeResources(Consumer<String> fn) {
        CrtResource.collectNativeResource(resource -> {
            String str = String.format(" * Address: %d: %s", resource.nativeHandle, resource.toString());
            fn.accept(str);
        });
    }

    public static void collectNativeResource(Consumer<ResourceInstance> fn) {
        for (Map.Entry<Long, ResourceInstance> entry : NATIVE_RESOURCES.entrySet()) {
            fn.accept(entry.getValue());
        }
    }

    public static void logNativeResources() {
        Log.log(Log.LogLevel.Debug, Log.LogSubject.JavaCrtResource, "Dumping native object set:");
        CrtResource.collectNativeResource(resource -> Log.log(Log.LogLevel.Debug, Log.LogSubject.JavaCrtResource, resource.getWrapper().getResourceLogDescription()));
    }

    private static void incrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("incrementNativeObjectCount - count = %d", ++resourceCount));
        }
        finally {
            lock.unlock();
        }
    }

    private static void decrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(Log.LogLevel.Trace, Log.LogSubject.JavaCrtResource, String.format("decrementNativeObjectCount - count = %d", --resourceCount));
            if (resourceCount == 0) {
                emptyResources.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void waitForNoResources() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            long timeout = System.currentTimeMillis() + 10000L;
            while (resourceCount != 0 && System.currentTimeMillis() < timeout) {
                emptyResources.await(1L, TimeUnit.SECONDS);
            }
            if (resourceCount != 0) {
                Log.log(Log.LogLevel.Error, Log.LogSubject.JavaCrtResource, "waitForNoResources - timeOut");
                CrtResource.logNativeResources();
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Timeout waiting for resource count to drop to zero");
        }
        finally {
            lock.unlock();
        }
    }

    static {
        new CRT();
    }

    public class ResourceInstance {
        public final long nativeHandle;
        public final String canonicalName;
        private Throwable instantiation;
        private CrtResource wrapper;

        public ResourceInstance(CrtResource wrapper, long handle, String name) {
            this.nativeHandle = handle;
            this.canonicalName = name;
            this.wrapper = wrapper;
            try {
                throw new RuntimeException();
            }
            catch (RuntimeException ex) {
                this.instantiation = ex;
                return;
            }
        }

        public String location() {
            String str = "";
            StackTraceElement[] stack = this.instantiation.getStackTrace();
            for (int frameIdx = 2; frameIdx < stack.length; ++frameIdx) {
                StackTraceElement frame = stack[frameIdx];
                str = str + frame.toString() + "\n";
            }
            return str;
        }

        public String toString() {
            String str = this.canonicalName + " allocated at:\n";
            str = str + this.location();
            return str;
        }

        public CrtResource getWrapper() {
            return this.wrapper;
        }
    }
}

