/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class MqttClient
extends CrtResource {
    private TlsContext tlsContext;

    public MqttClient() throws CrtRuntimeException {
        try (ClientBootstrap bootstrap = new ClientBootstrap(1);){
            this.acquireNativeHandle(MqttClient.mqttClientNew(bootstrap.getNativeHandle()));
            this.addReferenceTo(bootstrap);
        }
    }

    public MqttClient(ClientBootstrap clientBootstrap) throws CrtRuntimeException {
        this.acquireNativeHandle(MqttClient.mqttClientNew(clientBootstrap.getNativeHandle()));
        this.addReferenceTo(clientBootstrap);
    }

    public MqttClient(ClientBootstrap clientBootstrap, TlsContext context) throws CrtRuntimeException {
        this.acquireNativeHandle(MqttClient.mqttClientNew(clientBootstrap.getNativeHandle()));
        this.addReferenceTo(clientBootstrap);
        this.addReferenceTo(context);
        this.tlsContext = context;
    }

    public TlsContext getTlsContext() {
        return this.tlsContext;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            MqttClient.mqttClientDestroy(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native long mqttClientNew(long var0) throws CrtRuntimeException;

    private static native void mqttClientDestroy(long var0);
}

