/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.EventLoopGroup;

public class HostResolver
extends CrtResource {
    private static final int DEFAULT_MAX_ENTRIES = 8;

    public HostResolver(EventLoopGroup elg) throws CrtRuntimeException {
        this(elg, 8);
    }

    public HostResolver(EventLoopGroup elg, int maxEntries) throws CrtRuntimeException {
        this.acquireNativeHandle(HostResolver.hostResolverNew(elg.getNativeHandle(), maxEntries));
        this.addReferenceTo(elg);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HostResolver.hostResolverRelease(this.getNativeHandle());
        }
    }

    private static native long hostResolverNew(long var0, int var2) throws CrtRuntimeException;

    private static native void hostResolverRelease(long var0);
}

