/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.HostResolver;

public final class ClientBootstrap
extends CrtResource {
    public ClientBootstrap(int numThreads) throws CrtRuntimeException {
        try (EventLoopGroup elg = new EventLoopGroup(numThreads);
             HostResolver hr = new HostResolver(elg);){
            this.acquireNativeHandle(ClientBootstrap.clientBootstrapNew(elg.getNativeHandle(), hr.getNativeHandle()));
            this.addReferenceTo(hr);
            this.addReferenceTo(elg);
        }
    }

    public ClientBootstrap(EventLoopGroup elg, HostResolver hr) throws CrtRuntimeException {
        this.acquireNativeHandle(ClientBootstrap.clientBootstrapNew(elg.getNativeHandle(), hr.getNativeHandle()));
        this.addReferenceTo(hr);
        this.addReferenceTo(elg);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ClientBootstrap.clientBootstrapDestroy(this.getNativeHandle());
        }
    }

    private static native long clientBootstrapNew(long var0, long var2) throws CrtRuntimeException;

    private static native void clientBootstrapDestroy(long var0);
}

