/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public class HttpHeader {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final CharsetEncoder ISO_8859_1 = StandardCharsets.ISO_8859_1.newEncoder();
    private byte[] name;
    private byte[] value;

    private HttpHeader() {
    }

    public HttpHeader(String name, String value) {
        if (!ISO_8859_1.canEncode(name)) {
            throw new IllegalArgumentException("Can't encode Http Header name: " + name);
        }
        if (!ISO_8859_1.canEncode(value)) {
            throw new IllegalArgumentException("Can't encode Http Header Value: " + value);
        }
        this.name = name.getBytes(UTF8);
        this.value = value.getBytes(UTF8);
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return new String(this.name, UTF8);
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return new String(this.value, UTF8);
    }

    public String toString() {
        return this.getName() + ":" + this.getValue();
    }
}

