/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.TlsContextOptions;

public final class TlsContext
extends CrtResource {
    public TlsContext(TlsContextOptions options) throws CrtRuntimeException {
        this.acquireNativeHandle(TlsContext.tlsContextNew(options.getNativeHandle()));
    }

    public TlsContext() throws CrtRuntimeException {
        try (TlsContextOptions options = new TlsContextOptions();){
            this.acquireNativeHandle(TlsContext.tlsContextNew(options.getNativeHandle()));
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            TlsContext.tlsContextDestroy(this.getNativeHandle());
        }
    }

    private static native long tlsContextNew(long var0) throws CrtRuntimeException;

    private static native void tlsContextDestroy(long var0);
}

