/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.CrtByteBuffer;

public class HttpStream
extends CrtResource {
    private CrtByteBuffer streamBuffer;

    protected HttpStream(CrtByteBuffer streamBuffer, long ptr) {
        this.streamBuffer = streamBuffer;
        this.acquireNativeHandle(ptr);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            this.streamBuffer.releaseBackToPool();
            this.streamBuffer = null;
            HttpStream.httpStreamRelease(this.getNativeHandle());
        }
    }

    public void incrementWindow(int windowSize) {
        if (windowSize < 0) {
            throw new IllegalArgumentException("windowSize must be >= 0. Actual value: " + windowSize);
        }
        if (!this.isNull()) {
            HttpStream.httpStreamIncrementWindow(this.getNativeHandle(), windowSize);
        }
    }

    public int getResponseStatusCode() {
        if (!this.isNull()) {
            return HttpStream.httpStreamGetResponseStatusCode(this.getNativeHandle());
        }
        throw new IllegalStateException("Can't get Status Code on Closed Stream");
    }

    private static native void httpStreamRelease(long var0);

    private static native void httpStreamIncrementWindow(long var0, int var2);

    private static native int httpStreamGetResponseStatusCode(long var0);
}

