/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Locale;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;

public final class CRT {
    private static final String CRT_LIB_NAME = "aws-crt-jni";
    public static final int AWS_CRT_SUCCESS = 0;

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String getOSIdentifier() throws UnknownPlatformException {
        String name = CRT.normalize(System.getProperty("os.name"));
        if (name.contains("windows")) {
            return "windows";
        }
        if (name.contains("linux")) {
            return "linux";
        }
        if (name.contains("freebsd")) {
            return "freebsd";
        }
        if (name.contains("macosx")) {
            return "osx";
        }
        if (name.contains("sun os") || name.contains("sunos") || name.contains("solaris")) {
            return "solaris";
        }
        if (name.contains("android")) {
            return "android";
        }
        throw new UnknownPlatformException("AWS CRT: OS not supported: " + name);
    }

    private static String getArchIdentifier() throws UnknownPlatformException {
        String arch = CRT.normalize(System.getProperty("os.arch"));
        if (arch.matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (arch.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (arch.startsWith("armeabi")) {
            if (arch.contains("v7")) {
                return "armv7";
            }
            return "armv6";
        }
        if (arch.startsWith("arm64") && arch.contains("v8")) {
            return "armv8";
        }
        throw new UnknownPlatformException("AWS CRT: architecture not supported: " + arch);
    }

    private static void loadLibraryFromJar() {
        try {
            String prefix = "AWSCRT_" + new Date().getTime();
            String libraryName = System.mapLibraryName(CRT_LIB_NAME);
            String libraryPath = "/" + CRT.getOSIdentifier() + "/" + CRT.getArchIdentifier() + "/" + libraryName;
            Path libTempPath = Files.createTempFile(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), prefix, libraryName, new FileAttribute[0]);
            try (InputStream in = CRT.class.getResourceAsStream(libraryPath);){
                if (in == null) {
                    throw new IOException("Unable to open library in jar for AWS CRT: " + libraryPath);
                }
                Files.deleteIfExists(libTempPath);
                Files.copy(in, libTempPath, new CopyOption[0]);
            }
            File tempSharedLib = libTempPath.toFile();
            if (!tempSharedLib.setExecutable(true)) {
                throw new CrtRuntimeException("Unable to make shared library executable");
            }
            if (!tempSharedLib.setWritable(false)) {
                throw new CrtRuntimeException("Unable to make shared library read-only");
            }
            if (!tempSharedLib.setReadable(true)) {
                throw new CrtRuntimeException("Unable to make shared library readable");
            }
            tempSharedLib.deleteOnExit();
            System.load(libTempPath.toString());
            CRT.awsCrtInit();
            try {
                Log.initLoggingFromSystemProperties();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (CrtRuntimeException crtex) {
            System.err.println("Unable to initialize AWS CRT: " + crtex.toString());
            crtex.printStackTrace();
        }
        catch (UnknownPlatformException upe) {
            System.err.println("Unable to determine platform for AWS CRT: " + upe.toString());
            upe.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("Unable to unpack AWS CRT lib: " + ex.toString());
            ex.printStackTrace();
        }
    }

    private static native void awsCrtInit() throws CrtRuntimeException;

    public static native String awsErrorString(int var0);

    static {
        try {
            System.loadLibrary(CRT_LIB_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            CRT.loadLibraryFromJar();
        }
    }

    public static class UnknownPlatformException
    extends Exception {
        UnknownPlatformException(String message) {
            super(message);
        }
    }
}

