/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.nio.ByteBuffer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.CrtBufferPool;

public class CrtByteBuffer
extends CrtResource {
    private CrtBufferPool pool;
    private final ByteBuffer directBuffer;

    public static CrtByteBuffer alloc(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be >= 0");
        }
        return CrtByteBuffer.newCrtByteBuffer(size);
    }

    private CrtByteBuffer(ByteBuffer javaBuffer, long nativeBufferPtr) {
        this.directBuffer = javaBuffer;
        this.acquire(nativeBufferPtr);
    }

    public void releaseBackToPool() {
        if (this.pool == null) {
            throw new IllegalStateException("No Pool Configured");
        }
        this.pool.releaseBuffer(this);
    }

    public ByteBuffer getBuffer() {
        if (this.isNull()) {
            throw new IllegalStateException("This CrtByteBuffer has been closed");
        }
        return this.directBuffer;
    }

    public void wipe() {
        CrtByteBuffer.zeroCrtByteBuffer(this.native_ptr(), this.directBuffer.capacity());
        this.directBuffer.clear();
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            CrtByteBuffer.releaseCrtByteBuffer(this.release());
        }
        super.close();
    }

    protected CrtByteBuffer withPool(CrtBufferPool pool) {
        if (this.pool != null) {
            throw new IllegalStateException("Pool already configured");
        }
        this.pool = pool;
        return this;
    }

    private static native CrtByteBuffer newCrtByteBuffer(int var0);

    private static native void zeroCrtByteBuffer(long var0, int var2);

    private static native void releaseCrtByteBuffer(long var0);
}

