/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.CrtByteBuffer;

public class CrtBufferPool
extends CrtResource {
    private final int numBuffers;
    private final int bufferSize;
    private final Queue<CrtByteBuffer> idleBuffers = new ConcurrentLinkedQueue<CrtByteBuffer>();
    private final Queue<CompletableFuture<CrtByteBuffer>> bufferAcquisitionRequests = new ConcurrentLinkedQueue<CompletableFuture<CrtByteBuffer>>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public CrtBufferPool(int numBuffers, int bufferSize) {
        this.numBuffers = numBuffers;
        this.bufferSize = bufferSize;
        for (int i = 0; i < numBuffers; ++i) {
            this.idleBuffers.add(this.own(CrtByteBuffer.alloc(bufferSize).withPool(this)));
        }
    }

    private synchronized void completeFutureIfPossible() {
        CompletableFuture<CrtByteBuffer> bufferRequest = this.bufferAcquisitionRequests.peek();
        CrtByteBuffer idleBuffer = this.idleBuffers.peek();
        if (bufferRequest == null || idleBuffer == null) {
            return;
        }
        this.bufferAcquisitionRequests.remove();
        this.idleBuffers.remove();
        bufferRequest.complete(idleBuffer);
    }

    public CompletableFuture<CrtByteBuffer> acquireBuffer() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("CrtBufferPool has been closed, can't acquire new Buffers");
        }
        CompletableFuture<CrtByteBuffer> bufferRequest = new CompletableFuture<CrtByteBuffer>();
        this.bufferAcquisitionRequests.add(bufferRequest);
        this.completeFutureIfPossible();
        return bufferRequest;
    }

    public void releaseBuffer(CrtByteBuffer idleBuffer) {
        idleBuffer.wipe();
        this.idleBuffers.add(idleBuffer);
        this.completeFutureIfPossible();
    }

    private void closePendingAcquisitions(Throwable throwable) {
        while (this.bufferAcquisitionRequests.size() > 0) {
            CompletableFuture<CrtByteBuffer> future = this.bufferAcquisitionRequests.poll();
            if (future == null) continue;
            future.completeExceptionally(throwable);
        }
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.closePendingAcquisitions(new RuntimeException("CrtBufferPool is Closing. Closing Pending Buffer Acquisitions."));
        if (this.idleBuffers.size() != this.numBuffers) {
            throw new IllegalStateException("Can't close CrtBufferPool yet since some buffers are still in use");
        }
        super.close();
    }
}

