/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.HostResolver;

public final class ClientBootstrap
extends CrtResource {
    private final HostResolver hostResolver;
    private final EventLoopGroup elg;

    public ClientBootstrap(int numThreads) throws CrtRuntimeException {
        this.elg = this.own(new EventLoopGroup(numThreads));
        this.hostResolver = this.own(new HostResolver(this.elg));
        this.acquire(ClientBootstrap.clientBootstrapNew(this.elg.native_ptr(), this.hostResolver.native_ptr()));
    }

    public ClientBootstrap(EventLoopGroup elg, HostResolver hr) throws CrtRuntimeException {
        this.hostResolver = hr;
        this.elg = elg;
        this.acquire(ClientBootstrap.clientBootstrapNew(elg.native_ptr(), this.hostResolver.native_ptr()));
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            ClientBootstrap.clientBootstrapDestroy(this.release());
        }
        super.close();
    }

    private static native long clientBootstrapNew(long var0, long var2) throws CrtRuntimeException;

    private static native void clientBootstrapDestroy(long var0);
}

