/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.CrtBufferPool;
import software.amazon.awssdk.crt.io.CrtByteBuffer;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class HttpConnectionPoolManager
extends CrtResource {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 16384;
    public static final int DEFAULT_MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final ClientBootstrap clientBootstrap;
    private final SocketOptions socketOptions;
    private final TlsContext tlsContext;
    private final int windowSize;
    private final URI uri;
    private final int port;
    private final boolean useTls;
    private final int maxConnections;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private final CrtBufferPool bufferPool;
    private final Queue<CompletableFuture<HttpConnection>> connectionAcquisitionRequests = new ConcurrentLinkedQueue<CompletableFuture<HttpConnection>>();

    public HttpConnectionPoolManager(ClientBootstrap clientBootstrap, SocketOptions socketOptions, TlsContext tlsContext, URI uri) {
        this(clientBootstrap, socketOptions, tlsContext, uri, 16384, Integer.MAX_VALUE, 2);
    }

    public HttpConnectionPoolManager(ClientBootstrap clientBootstrap, SocketOptions socketOptions, TlsContext tlsContext, URI uri, int bufferSize, int windowSize, int maxConnections) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI does not have a Scheme");
        }
        if (!HTTP.equals(uri.getScheme()) && !HTTPS.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI has unknown Scheme");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI does not have a Host name");
        }
        if (clientBootstrap == null || clientBootstrap.isNull()) {
            throw new IllegalArgumentException("ClientBootstrap must not be null");
        }
        if (socketOptions == null || socketOptions.isNull()) {
            throw new IllegalArgumentException("SocketOptions must not be null");
        }
        if (HTTPS.equals(uri.getScheme()) && tlsContext == null) {
            throw new IllegalArgumentException("TlsContext must not be null if https is used");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer Size must be greater than zero.");
        }
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window Size must be greater than zero.");
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections must be greater than zero.");
        }
        int port = uri.getPort();
        if (port == -1) {
            if (HTTP.equals(uri.getScheme())) {
                port = 80;
            }
            if (HTTPS.equals(uri.getScheme())) {
                port = 443;
            }
        }
        this.clientBootstrap = clientBootstrap;
        this.socketOptions = socketOptions;
        this.tlsContext = tlsContext;
        this.windowSize = windowSize;
        this.uri = uri;
        this.port = port;
        this.useTls = HTTPS.equals(uri.getScheme());
        this.maxConnections = maxConnections;
        this.bufferPool = this.own(new CrtBufferPool(maxConnections, bufferSize));
        this.acquire(HttpConnectionPoolManager.httpConnectionManagerNew(this, clientBootstrap.native_ptr(), socketOptions.native_ptr(), this.useTls ? tlsContext.native_ptr() : 0L, windowSize, uri.getHost(), port, maxConnections));
    }

    private void onConnectionAcquired(long connection, int errorCode) {
        CompletableFuture<HttpConnection> connectionRequest = this.connectionAcquisitionRequests.poll();
        if (connectionRequest == null) {
            throw new IllegalStateException("No Future for Connection Acquisition");
        }
        if (errorCode != 0) {
            connectionRequest.completeExceptionally(new HttpException(errorCode));
            return;
        }
        HttpConnection conn = new HttpConnection(this, connection);
        connectionRequest.complete(conn);
    }

    protected CompletableFuture<CrtByteBuffer> acquireBuffer() {
        return this.bufferPool.acquireBuffer();
    }

    public CompletableFuture<HttpConnection> acquireConnection() {
        if (this.isClosed.get() || this.isNull()) {
            throw new IllegalStateException("HttpConnectionPoolManager has been closed, can't acquire new connections");
        }
        CompletableFuture<HttpConnection> connRequest = new CompletableFuture<HttpConnection>();
        this.connectionAcquisitionRequests.add(connRequest);
        HttpConnectionPoolManager.httpConnectionManagerAcquireConnection(this, this.native_ptr());
        return connRequest;
    }

    public void releaseConnection(HttpConnection conn) {
        conn.close();
    }

    protected void releaseConnectionPointer(long connection_ptr) {
        if (!this.isNull()) {
            HttpConnectionPoolManager.httpConnectionManagerReleaseConnection(this.native_ptr(), connection_ptr);
        }
    }

    private void closePendingAcquisitions(Throwable throwable) {
        while (this.connectionAcquisitionRequests.size() > 0) {
            CompletableFuture<HttpConnection> future = this.connectionAcquisitionRequests.poll();
            if (future == null) continue;
            future.completeExceptionally(throwable);
        }
    }

    private void onShutdownComplete() {
        this.shutdownComplete.complete(null);
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.closePendingAcquisitions(new RuntimeException("Connection Manager Closing. Closing Pending Connection Acquisitions."));
        if (!this.isNull()) {
            HttpConnectionPoolManager.httpConnectionManagerRelease(this.release());
        }
        try {
            this.shutdownComplete.get(60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.close();
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public URI getUri() {
        return this.uri;
    }

    private static native long httpConnectionManagerNew(HttpConnectionPoolManager var0, long var1, long var3, long var5, int var7, String var8, int var9, int var10) throws CrtRuntimeException;

    private static native void httpConnectionManagerRelease(long var0) throws CrtRuntimeException;

    private static native void httpConnectionManagerAcquireConnection(HttpConnectionPoolManager var0, long var1) throws CrtRuntimeException;

    private static native void httpConnectionManagerReleaseConnection(long var0, long var2) throws CrtRuntimeException;
}

