/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.CrtHttpStreamHandler;
import software.amazon.awssdk.crt.http.HttpConnectionPoolManager;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.io.CrtByteBuffer;

public class HttpConnection
extends CrtResource {
    private final HttpConnectionPoolManager manager;

    protected HttpConnection(HttpConnectionPoolManager manager, long connection) {
        this.manager = manager;
        this.acquire(connection);
    }

    public CompletableFuture<HttpStream> makeRequest(HttpRequest request, CrtHttpStreamHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpConnection has been closed, can't make requests on it.");
        }
        CompletableFuture<CrtByteBuffer> bufferFuture = this.manager.acquireBuffer();
        CompletableFuture<HttpStream> streamFuture = new CompletableFuture<HttpStream>();
        bufferFuture.whenComplete((crtBuffer, throwable) -> {
            if (throwable != null) {
                streamFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            try {
                HttpStream stream = HttpConnection.httpConnectionMakeRequest(this.native_ptr(), crtBuffer, request.getMethod(), request.getEncodedPath(), request.getHeaders(), streamHandler);
                if (stream == null || stream.isNull()) {
                    streamFuture.completeExceptionally(new RuntimeException("HttpStream creation failed"));
                }
                streamFuture.complete(stream);
            }
            catch (Exception e) {
                streamFuture.completeExceptionally(e);
            }
        });
        return streamFuture;
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            this.manager.releaseConnectionPointer(this.release());
            super.close();
        }
    }

    private static native HttpStream httpConnectionMakeRequest(long var0, CrtByteBuffer var2, String var3, String var4, HttpHeader[] var5, CrtHttpStreamHandler var6) throws CrtRuntimeException;
}

