/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.CrtHttpStreamHandler;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class HttpConnection
extends CrtResource {
    public static final int DEFAULT_MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_RESP_BODY_BUFFER_SIZE = 0x100000;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final ClientBootstrap clientBootstrap;
    private final SocketOptions socketOptions;
    private final TlsContext tlsContext;
    private final int windowSize;
    private final int respBodyBufSize;
    private final URI uri;
    private final int port;
    private final boolean useTls;
    private final CompletableFuture<HttpConnection> connectedFuture;
    private final CompletableFuture<Void> shutdownFuture;

    public static CompletableFuture<HttpConnection> createConnection(URI uri, ClientBootstrap bootstrap, SocketOptions socketOptions, TlsContext tlsContext) throws CrtRuntimeException {
        HttpConnection conn = new HttpConnection(uri, bootstrap, socketOptions, tlsContext, Integer.MAX_VALUE, 0x100000);
        return conn.connect();
    }

    public static CompletableFuture<HttpConnection> createConnection(URI uri, ClientBootstrap bootstrap, SocketOptions socketOptions, TlsContext tlsContext, int windowSize, int respBodyBufSize) throws CrtRuntimeException {
        HttpConnection conn = new HttpConnection(uri, bootstrap, socketOptions, tlsContext, windowSize, respBodyBufSize);
        return conn.connect();
    }

    private HttpConnection(URI uri, ClientBootstrap bootstrap, SocketOptions socketOptions, TlsContext tlsContext, int windowSize, int respBodyBufSize) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI does not have a Scheme");
        }
        if (!HTTP.equals(uri.getScheme()) && !HTTPS.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI has unknown Scheme");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI does not have a Host name");
        }
        if (bootstrap == null || bootstrap.isNull()) {
            throw new IllegalArgumentException("ClientBootstrap must not be null");
        }
        if (socketOptions == null || socketOptions.isNull()) {
            throw new IllegalArgumentException("SocketOptions must not be null");
        }
        if (HTTPS.equals(uri.getScheme()) && tlsContext == null) {
            throw new IllegalArgumentException("TlsContext must not be null if https is used");
        }
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window Size must be greater than zero.");
        }
        int port = uri.getPort();
        if (port == -1) {
            if (HTTP.equals(uri.getScheme())) {
                port = 80;
            }
            if (HTTPS.equals(uri.getScheme())) {
                port = 443;
            }
        }
        if (port <= 0 || 65535 < port) {
            throw new IllegalArgumentException("Invalid or missing port: " + uri);
        }
        this.uri = uri;
        this.port = port;
        this.useTls = HTTPS.equals(uri.getScheme());
        this.clientBootstrap = bootstrap;
        this.socketOptions = socketOptions;
        this.tlsContext = tlsContext;
        this.windowSize = windowSize;
        this.respBodyBufSize = respBodyBufSize;
        this.connectedFuture = new CompletableFuture();
        this.shutdownFuture = new CompletableFuture();
    }

    private CompletableFuture<HttpConnection> connect() throws CrtRuntimeException {
        if (!this.isNull()) {
            return this.connectedFuture;
        }
        this.acquire(HttpConnection.httpConnectionNew(this, this.clientBootstrap.native_ptr(), this.socketOptions.native_ptr(), this.useTls ? this.tlsContext.native_ptr() : 0L, this.windowSize, this.uri.getHost(), this.port));
        return this.connectedFuture;
    }

    public HttpStream makeRequest(HttpRequest request, CrtHttpStreamHandler streamHandler) throws CrtRuntimeException {
        if (this.isShutdownComplete() || this.isNull()) {
            throw new IllegalStateException("HttpConnection has been shut down, can't make requests on it.");
        }
        HttpStream stream = HttpConnection.httpConnectionMakeRequest(this.native_ptr(), this.respBodyBufSize, request.getMethod(), request.getEncodedPath(), request.getHeaders(), streamHandler);
        if (stream == null || stream.isNull()) {
            throw new IllegalStateException("HttpStream is null");
        }
        return stream;
    }

    @Override
    public void close() {
        if (this.didConnectSuccessfully() && !this.isShutdownComplete()) {
            try {
                this.shutdown().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.isNull()) {
            HttpConnection.httpConnectionRelease(this.release());
        }
        super.close();
    }

    private void onConnectionComplete(int errorCode) {
        if (errorCode == 0) {
            this.connectedFuture.complete(this);
        } else {
            this.close();
            this.connectedFuture.completeExceptionally(new HttpException(errorCode));
        }
    }

    private void onConnectionShutdown(int errorCode) {
        if (errorCode == 0) {
            this.shutdownFuture.complete(null);
        } else {
            this.shutdownFuture.completeExceptionally(new HttpException(errorCode));
        }
    }

    public CompletableFuture<Void> getShutdownFuture() {
        return this.shutdownFuture;
    }

    private boolean didConnectSuccessfully() {
        return this.connectedFuture.isDone() && !this.connectedFuture.isCompletedExceptionally();
    }

    private boolean isShutdownComplete() {
        return this.shutdownFuture.isDone();
    }

    public CompletableFuture<Void> shutdown() {
        if (this.isNull()) {
            return this.shutdownFuture;
        }
        try {
            HttpConnection.httpConnectionShutdown(this.native_ptr());
        }
        catch (CrtRuntimeException e) {
            this.shutdownFuture.completeExceptionally(e);
        }
        return this.shutdownFuture;
    }

    private static native long httpConnectionNew(HttpConnection var0, long var1, long var3, long var5, int var7, String var8, int var9) throws CrtRuntimeException;

    private static native void httpConnectionShutdown(long var0) throws CrtRuntimeException;

    private static native void httpConnectionRelease(long var0);

    private static native HttpStream httpConnectionMakeRequest(long var0, int var2, String var3, String var4, HttpHeader[] var5, CrtHttpStreamHandler var6) throws CrtRuntimeException;
}

