/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpStreamBase;

public class HttpStream
extends HttpStreamBase {
    protected HttpStream(long ptr) {
        super(ptr);
    }

    public void writeChunk(byte[] chunkData, boolean isFinalChunk, HttpStreamWriteChunkCompletionCallback chunkCompletionCallback) {
        if (chunkCompletionCallback == null) {
            throw new IllegalArgumentException("You must supply a chunkCompletionCallback");
        }
        if (chunkData == null) {
            throw new IllegalArgumentException("You must provide a non-null chunkData");
        }
        int error = HttpStream.httpStreamWriteChunk(this.getNativeHandle(), chunkData, isFinalChunk, chunkCompletionCallback);
        if (error != 0) {
            int lastError = CRT.awsLastError();
            throw new CrtRuntimeException(lastError);
        }
    }

    public CompletableFuture<Void> writeChunk(byte[] chunkData, boolean isFinalChunk) {
        final CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        HttpStreamWriteChunkCompletionCallback completionCallback = new HttpStreamWriteChunkCompletionCallback(){

            @Override
            public void onChunkCompleted(int errorCode) {
                if (errorCode == 0) {
                    completionFuture.complete(null);
                } else {
                    completionFuture.completeExceptionally(new CrtRuntimeException(errorCode));
                }
            }
        };
        this.writeChunk(chunkData, isFinalChunk, completionCallback);
        return completionFuture;
    }

    private static native int httpStreamWriteChunk(long var0, byte[] var2, boolean var3, HttpStreamWriteChunkCompletionCallback var4);

    public static interface HttpStreamWriteChunkCompletionCallback {
        public void onChunkCompleted(int var1);
    }
}

