/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics;
import software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions;
import software.amazon.awssdk.crt.mqtt5.Mqtt5WebsocketHandshakeTransformArgs;
import software.amazon.awssdk.crt.mqtt5.PublishResult;
import software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket;
import software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket;
import software.amazon.awssdk.crt.mqtt5.packets.PublishPacket;
import software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket;
import software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket;
import software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket;
import software.amazon.awssdk.crt.mqtt5.packets.UnsubscribePacket;

public class Mqtt5Client
extends CrtResource {
    private Consumer<Mqtt5WebsocketHandshakeTransformArgs> websocketHandshakeTransform;
    private boolean isConnected;

    public Mqtt5Client(Mqtt5ClientOptions options) throws CrtRuntimeException {
        ClientBootstrap bootstrap = options.getBootstrap();
        SocketOptions socketOptions = options.getSocketOptions();
        TlsContext tlsContext = options.getTlsContext();
        HttpProxyOptions proxyOptions = options.getHttpProxyOptions();
        ConnectPacket connectionOptions = options.getConnectOptions();
        this.websocketHandshakeTransform = options.getWebsocketHandshakeTransform();
        if (bootstrap == null) {
            bootstrap = ClientBootstrap.getOrCreateStaticDefault();
        }
        if (connectionOptions == null) {
            ConnectPacket.ConnectPacketBuilder connectBuilder = new ConnectPacket.ConnectPacketBuilder();
            connectionOptions = connectBuilder.build();
        }
        this.acquireNativeHandle(Mqtt5Client.mqtt5ClientNew(options, connectionOptions, bootstrap, this));
        if (bootstrap != null) {
            this.addReferenceTo(bootstrap);
        }
        if (socketOptions != null) {
            this.addReferenceTo(socketOptions);
        }
        if (tlsContext != null) {
            this.addReferenceTo(tlsContext);
        }
        if (proxyOptions != null && proxyOptions.getTlsContext() != null) {
            this.addReferenceTo(proxyOptions.getTlsContext());
        }
        this.isConnected = false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            Mqtt5Client.mqtt5ClientDestroy(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    public void start() throws CrtRuntimeException {
        Mqtt5Client.mqtt5ClientInternalStart(this.getNativeHandle());
    }

    public void stop(DisconnectPacket disconnectPacket) throws CrtRuntimeException {
        Mqtt5Client.mqtt5ClientInternalStop(this.getNativeHandle(), disconnectPacket);
    }

    public CompletableFuture<PublishResult> publish(PublishPacket publishPacket) {
        CompletableFuture<PublishResult> publishFuture = new CompletableFuture<PublishResult>();
        Mqtt5Client.mqtt5ClientInternalPublish(this.getNativeHandle(), publishPacket, publishFuture);
        return publishFuture;
    }

    public CompletableFuture<SubAckPacket> subscribe(SubscribePacket subscribePacket) {
        CompletableFuture<SubAckPacket> subscribeFuture = new CompletableFuture<SubAckPacket>();
        Mqtt5Client.mqtt5ClientInternalSubscribe(this.getNativeHandle(), subscribePacket, subscribeFuture);
        return subscribeFuture;
    }

    public CompletableFuture<UnsubAckPacket> unsubscribe(UnsubscribePacket unsubscribePacket) {
        CompletableFuture<UnsubAckPacket> unsubscribeFuture = new CompletableFuture<UnsubAckPacket>();
        Mqtt5Client.mqtt5ClientInternalUnsubscribe(this.getNativeHandle(), unsubscribePacket, unsubscribeFuture);
        return unsubscribeFuture;
    }

    public Mqtt5ClientOperationStatistics getOperationStatistics() {
        return Mqtt5Client.mqtt5ClientInternalGetOperationStatistics(this.getNativeHandle());
    }

    public synchronized boolean getIsConnected() {
        return this.isConnected;
    }

    private synchronized void setIsConnected(boolean connected) {
        this.isConnected = connected;
    }

    private void onWebsocketHandshake(HttpRequest handshakeRequest, long nativeUserData) {
        CompletableFuture<HttpRequest> future = new CompletableFuture<HttpRequest>();
        future.whenComplete((x, throwable) -> Mqtt5Client.mqtt5ClientInternalWebsocketHandshakeComplete(this.getNativeHandle(), x != null ? x.marshalForJni() : null, throwable, nativeUserData));
        Mqtt5WebsocketHandshakeTransformArgs args = new Mqtt5WebsocketHandshakeTransformArgs(this, handshakeRequest, future);
        Consumer<Mqtt5WebsocketHandshakeTransformArgs> transform = this.websocketHandshakeTransform;
        if (transform != null) {
            transform.accept(args);
        } else {
            args.complete(handshakeRequest);
        }
    }

    private static native long mqtt5ClientNew(Mqtt5ClientOptions var0, ConnectPacket var1, ClientBootstrap var2, Mqtt5Client var3) throws CrtRuntimeException;

    private static native void mqtt5ClientDestroy(long var0);

    private static native void mqtt5ClientInternalStart(long var0);

    private static native void mqtt5ClientInternalStop(long var0, DisconnectPacket var2);

    private static native void mqtt5ClientInternalPublish(long var0, PublishPacket var2, CompletableFuture<PublishResult> var3);

    private static native void mqtt5ClientInternalSubscribe(long var0, SubscribePacket var2, CompletableFuture<SubAckPacket> var3);

    private static native void mqtt5ClientInternalUnsubscribe(long var0, UnsubscribePacket var2, CompletableFuture<UnsubAckPacket> var3);

    private static native void mqtt5ClientInternalWebsocketHandshakeComplete(long var0, byte[] var2, Throwable var3, long var4) throws CrtRuntimeException;

    private static native Mqtt5ClientOperationStatistics mqtt5ClientInternalGetOperationStatistics(long var0);
}

