/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;

public class ResumeToken {
    private int nativeType = S3MetaRequestOptions.MetaRequestType.PUT_OBJECT.getNativeValue();
    private long partSize;
    private long totalNumParts;
    private long numPartsCompleted;
    private String uploadId;

    public ResumeToken(PutResumeTokenBuilder builder) {
        this.partSize = builder.partSize;
        this.totalNumParts = builder.totalNumParts;
        this.numPartsCompleted = builder.numPartsCompleted;
        this.uploadId = builder.uploadId;
    }

    public S3MetaRequestOptions.MetaRequestType getType() {
        return S3MetaRequestOptions.MetaRequestType.getEnumValueFromInteger(this.nativeType);
    }

    public long getPartSize() {
        return this.partSize;
    }

    public long getTotalNumParts() {
        return this.totalNumParts;
    }

    public long getNumPartsCompleted() {
        return this.numPartsCompleted;
    }

    public String getUploadId() {
        if (this.getType() != S3MetaRequestOptions.MetaRequestType.PUT_OBJECT) {
            throw new IllegalArgumentException("ResumeToken - upload id is only defined for Put Object Resume tokens");
        }
        return this.uploadId;
    }

    public static class PutResumeTokenBuilder {
        private long partSize;
        private long totalNumParts;
        private long numPartsCompleted;
        private String uploadId;

        public PutResumeTokenBuilder withPartSize(long partSize) {
            this.partSize = partSize;
            return this;
        }

        public PutResumeTokenBuilder withTotalNumParts(long totalNumParts) {
            this.totalNumParts = totalNumParts;
            return this;
        }

        public PutResumeTokenBuilder withNumPartsCompleted(long numPartsCompleted) {
            this.numPartsCompleted = numPartsCompleted;
            return this;
        }

        public PutResumeTokenBuilder withUploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        ResumeToken build() {
            return new ResumeToken(this);
        }
    }
}

