/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.Delete;
import com.amazonaws.s3.model.RequestPayer;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class DeleteObjectsRequest {
    String bucket;
    Delete delete;
    String mFA;
    RequestPayer requestPayer;
    Boolean bypassGovernanceRetention;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    DeleteObjectsRequest() {
        this.bucket = "";
        this.delete = null;
        this.mFA = "";
        this.requestPayer = null;
        this.bypassGovernanceRetention = null;
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected DeleteObjectsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delete = builder.delete;
        this.mFA = builder.mFA;
        this.requestPayer = builder.requestPayer;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(DeleteObjectsRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof DeleteObjectsRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public Delete delete() {
        return this.delete;
    }

    public String mFA() {
        return this.mFA;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public Boolean bypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        Delete delete;
        String mFA;
        RequestPayer requestPayer;
        Boolean bypassGovernanceRetention;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsRequest model) {
            this.bucket(model.bucket);
            this.delete(model.delete);
            this.mFA(model.mFA);
            this.requestPayer(model.requestPayer);
            this.bypassGovernanceRetention(model.bypassGovernanceRetention);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public DeleteObjectsRequest build() {
            return new DeleteObjectsRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder delete(Delete delete) {
            this.delete = delete;
            return this;
        }

        @Override
        public final Builder mFA(String mFA) {
            this.mFA = mFA;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public Delete delete() {
            return this.delete;
        }

        public String mFA() {
            return this.mFA;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public Boolean bypassGovernanceRetention() {
            return this.bypassGovernanceRetention;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder delete(Delete var1);

        public Builder mFA(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder bypassGovernanceRetention(Boolean var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public DeleteObjectsRequest build();
    }
}

