/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class ProfileCredentialsProvider
extends CredentialsProvider {
    public static ProfileCredentialsProvider create() {
        return ProfileCredentialsProvider.builder().build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static byte[] toByteArray(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    private static long toNativeHandle(CrtResource crtResource) {
        return crtResource == null ? 0L : crtResource.getNativeHandle();
    }

    private ProfileCredentialsProvider(BuilderImpl builder) {
        try (ClientBootstrap bootstrap = builder.clientBootstrap == null ? new ClientBootstrap(null, null) : builder.clientBootstrap;){
            long nativeHandle = ProfileCredentialsProvider.profileCredentialsProviderNew(this, ProfileCredentialsProvider.toNativeHandle(bootstrap), ProfileCredentialsProvider.toNativeHandle(builder.tlsContext), ProfileCredentialsProvider.toByteArray(builder.profileName), ProfileCredentialsProvider.toByteArray(builder.configFileNameOverride), ProfileCredentialsProvider.toByteArray(builder.credentialsFileNameOverride));
            this.acquireNativeHandle(nativeHandle);
            this.addReferenceTo(bootstrap);
            if (builder.tlsContext != null) {
                this.addReferenceTo(builder.tlsContext);
            }
            if (builder.clientBootstrap != null) {
                bootstrap.addRef();
            }
        }
    }

    private static native long profileCredentialsProviderNew(ProfileCredentialsProvider var0, long var1, long var3, byte[] var5, byte[] var6, byte[] var7);

    static final class BuilderImpl
    implements Builder {
        private ClientBootstrap clientBootstrap;
        private TlsContext tlsContext;
        private String profileName;
        private String configFileNameOverride;
        private String credentialsFileNameOverride;

        BuilderImpl() {
        }

        @Override
        public Builder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        @Override
        public Builder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        @Override
        public Builder withProfileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        @Override
        public Builder withConfigFileNameOverride(String configFileNameOverride) {
            this.configFileNameOverride = configFileNameOverride;
            return this;
        }

        @Override
        public Builder withCredentialsFileNameOverride(String credentialsFileNameOverride) {
            this.credentialsFileNameOverride = credentialsFileNameOverride;
            return this;
        }

        @Override
        public ProfileCredentialsProvider build() {
            return new ProfileCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder withClientBootstrap(ClientBootstrap var1);

        public Builder withTlsContext(TlsContext var1);

        public Builder withProfileName(String var1);

        public Builder withConfigFileNameOverride(String var1);

        public Builder withCredentialsFileNameOverride(String var1);

        public ProfileCredentialsProvider build();
    }
}

