/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.Protocol;
import java.util.Objects;

public class Redirect {
    String hostName;
    String httpRedirectCode;
    Protocol protocol;
    String replaceKeyPrefixWith;
    String replaceKeyWith;

    Redirect() {
        this.hostName = "";
        this.httpRedirectCode = "";
        this.protocol = null;
        this.replaceKeyPrefixWith = "";
        this.replaceKeyWith = "";
    }

    protected Redirect(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.httpRedirectCode = builder.httpRedirectCode;
        this.protocol = builder.protocol;
        this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
        this.replaceKeyWith = builder.replaceKeyWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Redirect.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Redirect;
    }

    public String hostName() {
        return this.hostName;
    }

    public String httpRedirectCode() {
        return this.httpRedirectCode;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String replaceKeyPrefixWith() {
        return this.replaceKeyPrefixWith;
    }

    public String replaceKeyWith() {
        return this.replaceKeyWith;
    }

    protected static class BuilderImpl
    implements Builder {
        String hostName;
        String httpRedirectCode;
        Protocol protocol;
        String replaceKeyPrefixWith;
        String replaceKeyWith;

        protected BuilderImpl() {
        }

        private BuilderImpl(Redirect model) {
            this.hostName(model.hostName);
            this.httpRedirectCode(model.httpRedirectCode);
            this.protocol(model.protocol);
            this.replaceKeyPrefixWith(model.replaceKeyPrefixWith);
            this.replaceKeyWith(model.replaceKeyWith);
        }

        @Override
        public Redirect build() {
            return new Redirect(this);
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        @Override
        public final Builder httpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
            return this;
        }

        @Override
        public final Builder replaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String hostName() {
            return this.hostName;
        }

        public String httpRedirectCode() {
            return this.httpRedirectCode;
        }

        public Protocol protocol() {
            return this.protocol;
        }

        public String replaceKeyPrefixWith() {
            return this.replaceKeyPrefixWith;
        }

        public String replaceKeyWith() {
            return this.replaceKeyWith;
        }
    }

    public static interface Builder {
        public Builder hostName(String var1);

        public Builder httpRedirectCode(String var1);

        public Builder protocol(Protocol var1);

        public Builder replaceKeyPrefixWith(String var1);

        public Builder replaceKeyWith(String var1);

        public Redirect build();
    }
}

