/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.BucketCannedACL;
import com.amazonaws.s3.model.CreateBucketConfiguration;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class CreateBucketRequest {
    BucketCannedACL aCL;
    String bucket;
    CreateBucketConfiguration createBucketConfiguration;
    String grantFullControl;
    String grantRead;
    String grantReadACP;
    String grantWrite;
    String grantWriteACP;
    Boolean objectLockEnabledForBucket;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    CreateBucketRequest() {
        this.aCL = null;
        this.bucket = "";
        this.createBucketConfiguration = null;
        this.grantFullControl = "";
        this.grantRead = "";
        this.grantReadACP = "";
        this.grantWrite = "";
        this.grantWriteACP = "";
        this.objectLockEnabledForBucket = null;
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected CreateBucketRequest(BuilderImpl builder) {
        this.aCL = builder.aCL;
        this.bucket = builder.bucket;
        this.createBucketConfiguration = builder.createBucketConfiguration;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
        this.objectLockEnabledForBucket = builder.objectLockEnabledForBucket;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(CreateBucketRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof CreateBucketRequest;
    }

    public BucketCannedACL aCL() {
        return this.aCL;
    }

    public String bucket() {
        return this.bucket;
    }

    public CreateBucketConfiguration createBucketConfiguration() {
        return this.createBucketConfiguration;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWrite() {
        return this.grantWrite;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public Boolean objectLockEnabledForBucket() {
        return this.objectLockEnabledForBucket;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        BucketCannedACL aCL;
        String bucket;
        CreateBucketConfiguration createBucketConfiguration;
        String grantFullControl;
        String grantRead;
        String grantReadACP;
        String grantWrite;
        String grantWriteACP;
        Boolean objectLockEnabledForBucket;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(CreateBucketRequest model) {
            this.aCL(model.aCL);
            this.bucket(model.bucket);
            this.createBucketConfiguration(model.createBucketConfiguration);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWrite(model.grantWrite);
            this.grantWriteACP(model.grantWriteACP);
            this.objectLockEnabledForBucket(model.objectLockEnabledForBucket);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public CreateBucketRequest build() {
            return new CreateBucketRequest(this);
        }

        @Override
        public final Builder aCL(BucketCannedACL aCL) {
            this.aCL = aCL;
            return this;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder createBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) {
            this.createBucketConfiguration = createBucketConfiguration;
            return this;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        @Override
        public final Builder objectLockEnabledForBucket(Boolean objectLockEnabledForBucket) {
            this.objectLockEnabledForBucket = objectLockEnabledForBucket;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public BucketCannedACL aCL() {
            return this.aCL;
        }

        public String bucket() {
            return this.bucket;
        }

        public CreateBucketConfiguration createBucketConfiguration() {
            return this.createBucketConfiguration;
        }

        public String grantFullControl() {
            return this.grantFullControl;
        }

        public String grantRead() {
            return this.grantRead;
        }

        public String grantReadACP() {
            return this.grantReadACP;
        }

        public String grantWrite() {
            return this.grantWrite;
        }

        public String grantWriteACP() {
            return this.grantWriteACP;
        }

        public Boolean objectLockEnabledForBucket() {
            return this.objectLockEnabledForBucket;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder aCL(BucketCannedACL var1);

        public Builder bucket(String var1);

        public Builder createBucketConfiguration(CreateBucketConfiguration var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWrite(String var1);

        public Builder grantWriteACP(String var1);

        public Builder objectLockEnabledForBucket(Boolean var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public CreateBucketRequest build();
    }
}

