/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.s3.S3ClientOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequest;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter;

public class S3Client
extends CrtResource {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public S3Client(S3ClientOptions options) throws CrtRuntimeException {
        TlsContext tlsCtx = options.getTlsContext();
        this.acquireNativeHandle(S3Client.s3ClientNew(this, options.getRegion().getBytes(UTF8), options.getEndpoint() != null ? options.getEndpoint().getBytes(UTF8) : null, options.getClientBootstrap().getNativeHandle(), tlsCtx != null ? tlsCtx.getNativeHandle() : 0L, options.getCredentialsProvider().getNativeHandle(), options.getPartSize(), options.getThroughputTargetGbps()));
        this.addReferenceTo(options.getClientBootstrap());
        this.addReferenceTo(options.getCredentialsProvider());
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public S3MetaRequest makeMetaRequest(S3MetaRequestOptions options) {
        if (options.getHttpRequest() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Http Request cannot be null.");
            return null;
        }
        if (options.getResponseHandler() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Response Handler cannot be null.");
            return null;
        }
        S3MetaRequest metaRequest = new S3MetaRequest();
        S3MetaRequestResponseHandlerNativeAdapter responseHandlerNativeAdapter = new S3MetaRequestResponseHandlerNativeAdapter(options.getResponseHandler());
        byte[] httpRequestBytes = options.getHttpRequest().marshalForJni();
        long metaRequestNativeHandle = S3Client.s3ClientMakeMetaRequest(this.getNativeHandle(), metaRequest, options.getMetaRequestType().getNativeValue(), httpRequestBytes, options.getHttpRequest().getBodyStream(), responseHandlerNativeAdapter);
        metaRequest.setMetaRequestNativeHandle(metaRequestNativeHandle);
        return metaRequest;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            S3Client.s3ClientDestroy(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long s3ClientNew(S3Client var0, byte[] var1, byte[] var2, long var3, long var5, long var7, long var9, double var11) throws CrtRuntimeException;

    private static native void s3ClientDestroy(long var0);

    private static native long s3ClientMakeMetaRequest(long var0, S3MetaRequest var2, int var3, byte[] var4, HttpRequestBodyStream var5, S3MetaRequestResponseHandlerNativeAdapter var6);
}

