/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.crt.CRT;

public class CrtRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    public final int errorCode;
    public final String errorName;
    private static final Pattern crtExFormat;

    public CrtRuntimeException(String msg) {
        super(msg);
        Matcher matcher = crtExFormat.matcher(msg);
        if (matcher.matches()) {
            this.errorName = matcher.group(1);
            this.errorCode = Integer.parseInt(matcher.group(2));
        } else {
            this.errorCode = -1;
            this.errorName = "UNKNOWN";
        }
    }

    public CrtRuntimeException(int errorCode, String errorName) {
        super(CRT.awsErrorString(errorCode));
        this.errorCode = errorCode;
        this.errorName = errorName;
    }

    public CrtRuntimeException(int errorCode) {
        super(CRT.awsErrorString(errorCode));
        this.errorCode = errorCode;
        this.errorName = CRT.awsErrorName(errorCode);
    }

    @Override
    public String toString() {
        return String.format("%s %s(%d)", super.toString(), this.errorName, this.errorCode);
    }

    static {
        new CRT();
        crtExFormat = Pattern.compile("aws_last_error: (.+)\\(([-0-9]+)\\),");
    }
}

