/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.GlacierJobParameters;
import com.amazonaws.s3.model.OutputLocation;
import com.amazonaws.s3.model.RestoreRequestType;
import com.amazonaws.s3.model.SelectParameters;
import com.amazonaws.s3.model.Tier;
import java.util.Objects;

public class RestoreRequest {
    Integer days;
    GlacierJobParameters glacierJobParameters;
    RestoreRequestType type;
    Tier tier;
    String description;
    SelectParameters selectParameters;
    OutputLocation outputLocation;

    RestoreRequest() {
        this.days = null;
        this.glacierJobParameters = null;
        this.type = null;
        this.tier = null;
        this.description = "";
        this.selectParameters = null;
        this.outputLocation = null;
    }

    protected RestoreRequest(BuilderImpl builder) {
        this.days = builder.days;
        this.glacierJobParameters = builder.glacierJobParameters;
        this.type = builder.type;
        this.tier = builder.tier;
        this.description = builder.description;
        this.selectParameters = builder.selectParameters;
        this.outputLocation = builder.outputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(RestoreRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof RestoreRequest;
    }

    public Integer days() {
        return this.days;
    }

    public GlacierJobParameters glacierJobParameters() {
        return this.glacierJobParameters;
    }

    public RestoreRequestType type() {
        return this.type;
    }

    public Tier tier() {
        return this.tier;
    }

    public String description() {
        return this.description;
    }

    public SelectParameters selectParameters() {
        return this.selectParameters;
    }

    public OutputLocation outputLocation() {
        return this.outputLocation;
    }

    protected static class BuilderImpl
    implements Builder {
        Integer days;
        GlacierJobParameters glacierJobParameters;
        RestoreRequestType type;
        Tier tier;
        String description;
        SelectParameters selectParameters;
        OutputLocation outputLocation;

        protected BuilderImpl() {
        }

        private BuilderImpl(RestoreRequest model) {
            this.days(model.days);
            this.glacierJobParameters(model.glacierJobParameters);
            this.type(model.type);
            this.tier(model.tier);
            this.description(model.description);
            this.selectParameters(model.selectParameters);
            this.outputLocation(model.outputLocation);
        }

        @Override
        public RestoreRequest build() {
            return new RestoreRequest(this);
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        @Override
        public final Builder glacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
            return this;
        }

        @Override
        public final Builder type(RestoreRequestType type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public final Builder selectParameters(SelectParameters selectParameters) {
            this.selectParameters = selectParameters;
            return this;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public Integer days() {
            return this.days;
        }

        public GlacierJobParameters glacierJobParameters() {
            return this.glacierJobParameters;
        }

        public RestoreRequestType type() {
            return this.type;
        }

        public Tier tier() {
            return this.tier;
        }

        public String description() {
            return this.description;
        }

        public SelectParameters selectParameters() {
            return this.selectParameters;
        }

        public OutputLocation outputLocation() {
            return this.outputLocation;
        }
    }

    public static interface Builder {
        public Builder days(Integer var1);

        public Builder glacierJobParameters(GlacierJobParameters var1);

        public Builder type(RestoreRequestType var1);

        public Builder tier(Tier var1);

        public Builder description(String var1);

        public Builder selectParameters(SelectParameters var1);

        public Builder outputLocation(OutputLocation var1);

        public RestoreRequest build();
    }
}

