/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.PublicAccessBlockConfiguration;
import java.util.Objects;

public class PutPublicAccessBlockRequest {
    String bucket;
    String contentMD5;
    PublicAccessBlockConfiguration publicAccessBlockConfiguration;
    String expectedBucketOwner;

    PutPublicAccessBlockRequest() {
        this.bucket = "";
        this.contentMD5 = "";
        this.publicAccessBlockConfiguration = null;
        this.expectedBucketOwner = "";
    }

    protected PutPublicAccessBlockRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutPublicAccessBlockRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutPublicAccessBlockRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return this.publicAccessBlockConfiguration;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String contentMD5;
        PublicAccessBlockConfiguration publicAccessBlockConfiguration;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutPublicAccessBlockRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public PutPublicAccessBlockRequest build() {
            return new PutPublicAccessBlockRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration var1);

        public Builder expectedBucketOwner(String var1);

        public PutPublicAccessBlockRequest build();
    }
}

