/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ObjectCannedACL;
import com.amazonaws.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.s3.model.ObjectLockMode;
import com.amazonaws.s3.model.RequestPayer;
import com.amazonaws.s3.model.ServerSideEncryption;
import com.amazonaws.s3.model.StorageClass;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public class PutObjectRequest {
    ObjectCannedACL aCL;
    byte[] body;
    String bucket;
    String cacheControl;
    String contentDisposition;
    String contentEncoding;
    String contentLanguage;
    Long contentLength;
    String contentMD5;
    String contentType;
    Instant expires;
    String grantFullControl;
    String grantRead;
    String grantReadACP;
    String grantWriteACP;
    String key;
    Map<String, String> metadata;
    ServerSideEncryption serverSideEncryption;
    StorageClass storageClass;
    String websiteRedirectLocation;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    String sSEKMSKeyId;
    String sSEKMSEncryptionContext;
    Boolean bucketKeyEnabled;
    RequestPayer requestPayer;
    String tagging;
    ObjectLockMode objectLockMode;
    Instant objectLockRetainUntilDate;
    ObjectLockLegalHoldStatus objectLockLegalHoldStatus;
    String expectedBucketOwner;

    PutObjectRequest() {
        this.aCL = null;
        this.body = null;
        this.bucket = "";
        this.cacheControl = "";
        this.contentDisposition = "";
        this.contentEncoding = "";
        this.contentLanguage = "";
        this.contentLength = null;
        this.contentMD5 = "";
        this.contentType = "";
        this.expires = null;
        this.grantFullControl = "";
        this.grantRead = "";
        this.grantReadACP = "";
        this.grantWriteACP = "";
        this.key = "";
        this.metadata = null;
        this.serverSideEncryption = null;
        this.storageClass = null;
        this.websiteRedirectLocation = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.sSEKMSKeyId = "";
        this.sSEKMSEncryptionContext = "";
        this.bucketKeyEnabled = null;
        this.requestPayer = null;
        this.tagging = "";
        this.objectLockMode = null;
        this.objectLockRetainUntilDate = null;
        this.objectLockLegalHoldStatus = null;
        this.expectedBucketOwner = "";
    }

    protected PutObjectRequest(BuilderImpl builder) {
        this.aCL = builder.aCL;
        this.body = builder.body;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.contentType = builder.contentType;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.sSEKMSKeyId = builder.sSEKMSKeyId;
        this.sSEKMSEncryptionContext = builder.sSEKMSEncryptionContext;
        this.bucketKeyEnabled = builder.bucketKeyEnabled;
        this.requestPayer = builder.requestPayer;
        this.tagging = builder.tagging;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
        this.objectLockLegalHoldStatus = builder.objectLockLegalHoldStatus;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutObjectRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutObjectRequest;
    }

    public ObjectCannedACL aCL() {
        return this.aCL;
    }

    public byte[] body() {
        return this.body;
    }

    public String bucket() {
        return this.bucket;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String contentType() {
        return this.contentType;
    }

    public Instant expires() {
        return this.expires;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ServerSideEncryption serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public String sSEKMSKeyId() {
        return this.sSEKMSKeyId;
    }

    public String sSEKMSEncryptionContext() {
        return this.sSEKMSEncryptionContext;
    }

    public Boolean bucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String tagging() {
        return this.tagging;
    }

    public ObjectLockMode objectLockMode() {
        return this.objectLockMode;
    }

    public Instant objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        ObjectCannedACL aCL;
        byte[] body;
        String bucket;
        String cacheControl;
        String contentDisposition;
        String contentEncoding;
        String contentLanguage;
        Long contentLength;
        String contentMD5;
        String contentType;
        Instant expires;
        String grantFullControl;
        String grantRead;
        String grantReadACP;
        String grantWriteACP;
        String key;
        Map<String, String> metadata;
        ServerSideEncryption serverSideEncryption;
        StorageClass storageClass;
        String websiteRedirectLocation;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        String sSEKMSKeyId;
        String sSEKMSEncryptionContext;
        Boolean bucketKeyEnabled;
        RequestPayer requestPayer;
        String tagging;
        ObjectLockMode objectLockMode;
        Instant objectLockRetainUntilDate;
        ObjectLockLegalHoldStatus objectLockLegalHoldStatus;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutObjectRequest model) {
            this.aCL(model.aCL);
            this.body(model.body);
            this.bucket(model.bucket);
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.contentLength(model.contentLength);
            this.contentMD5(model.contentMD5);
            this.contentType(model.contentType);
            this.expires(model.expires);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWriteACP(model.grantWriteACP);
            this.key(model.key);
            this.metadata(model.metadata);
            this.serverSideEncryption(model.serverSideEncryption);
            this.storageClass(model.storageClass);
            this.websiteRedirectLocation(model.websiteRedirectLocation);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.sSEKMSKeyId(model.sSEKMSKeyId);
            this.sSEKMSEncryptionContext(model.sSEKMSEncryptionContext);
            this.bucketKeyEnabled(model.bucketKeyEnabled);
            this.requestPayer(model.requestPayer);
            this.tagging(model.tagging);
            this.objectLockMode(model.objectLockMode);
            this.objectLockRetainUntilDate(model.objectLockRetainUntilDate);
            this.objectLockLegalHoldStatus(model.objectLockLegalHoldStatus);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }

        @Override
        public final Builder aCL(ObjectCannedACL aCL) {
            this.aCL = aCL;
            return this;
        }

        @Override
        public final Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder sSEKMSKeyId(String sSEKMSKeyId) {
            this.sSEKMSKeyId = sSEKMSKeyId;
            return this;
        }

        @Override
        public final Builder sSEKMSEncryptionContext(String sSEKMSEncryptionContext) {
            this.sSEKMSEncryptionContext = sSEKMSEncryptionContext;
            return this;
        }

        @Override
        public final Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        @Override
        public final Builder objectLockMode(ObjectLockMode objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        @Override
        public final Builder objectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public ObjectCannedACL aCL() {
            return this.aCL;
        }

        public byte[] body() {
            return this.body;
        }

        public String bucket() {
            return this.bucket;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String contentDisposition() {
            return this.contentDisposition;
        }

        public String contentEncoding() {
            return this.contentEncoding;
        }

        public String contentLanguage() {
            return this.contentLanguage;
        }

        public Long contentLength() {
            return this.contentLength;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String contentType() {
            return this.contentType;
        }

        public Instant expires() {
            return this.expires;
        }

        public String grantFullControl() {
            return this.grantFullControl;
        }

        public String grantRead() {
            return this.grantRead;
        }

        public String grantReadACP() {
            return this.grantReadACP;
        }

        public String grantWriteACP() {
            return this.grantWriteACP;
        }

        public String key() {
            return this.key;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        public ServerSideEncryption serverSideEncryption() {
            return this.serverSideEncryption;
        }

        public StorageClass storageClass() {
            return this.storageClass;
        }

        public String websiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public String sSEKMSKeyId() {
            return this.sSEKMSKeyId;
        }

        public String sSEKMSEncryptionContext() {
            return this.sSEKMSEncryptionContext;
        }

        public Boolean bucketKeyEnabled() {
            return this.bucketKeyEnabled;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String tagging() {
            return this.tagging;
        }

        public ObjectLockMode objectLockMode() {
            return this.objectLockMode;
        }

        public Instant objectLockRetainUntilDate() {
            return this.objectLockRetainUntilDate;
        }

        public ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
            return this.objectLockLegalHoldStatus;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder aCL(ObjectCannedACL var1);

        public Builder body(byte[] var1);

        public Builder bucket(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentLength(Long var1);

        public Builder contentMD5(String var1);

        public Builder contentType(String var1);

        public Builder expires(Instant var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder storageClass(StorageClass var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder sSEKMSKeyId(String var1);

        public Builder sSEKMSEncryptionContext(String var1);

        public Builder bucketKeyEnabled(Boolean var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder tagging(String var1);

        public Builder objectLockMode(ObjectLockMode var1);

        public Builder objectLockRetainUntilDate(Instant var1);

        public Builder objectLockLegalHoldStatus(ObjectLockLegalHoldStatus var1);

        public Builder expectedBucketOwner(String var1);

        public PutObjectRequest build();
    }
}

