/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.WebsiteConfiguration;
import java.util.Objects;

public class PutBucketWebsiteRequest {
    String bucket;
    String contentMD5;
    WebsiteConfiguration websiteConfiguration;
    String expectedBucketOwner;

    PutBucketWebsiteRequest() {
        this.bucket = "";
        this.contentMD5 = "";
        this.websiteConfiguration = null;
        this.expectedBucketOwner = "";
    }

    protected PutBucketWebsiteRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.websiteConfiguration = builder.websiteConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketWebsiteRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketWebsiteRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public WebsiteConfiguration websiteConfiguration() {
        return this.websiteConfiguration;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String contentMD5;
        WebsiteConfiguration websiteConfiguration;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketWebsiteRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.websiteConfiguration(model.websiteConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public PutBucketWebsiteRequest build() {
            return new PutBucketWebsiteRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder websiteConfiguration(WebsiteConfiguration websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public WebsiteConfiguration websiteConfiguration() {
            return this.websiteConfiguration;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder websiteConfiguration(WebsiteConfiguration var1);

        public Builder expectedBucketOwner(String var1);

        public PutBucketWebsiteRequest build();
    }
}

