/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.VersioningConfiguration;
import java.util.Objects;

public class PutBucketVersioningRequest {
    String bucket;
    String contentMD5;
    String mFA;
    VersioningConfiguration versioningConfiguration;
    String expectedBucketOwner;

    PutBucketVersioningRequest() {
        this.bucket = "";
        this.contentMD5 = "";
        this.mFA = "";
        this.versioningConfiguration = null;
        this.expectedBucketOwner = "";
    }

    protected PutBucketVersioningRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.mFA = builder.mFA;
        this.versioningConfiguration = builder.versioningConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketVersioningRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketVersioningRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String mFA() {
        return this.mFA;
    }

    public VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String contentMD5;
        String mFA;
        VersioningConfiguration versioningConfiguration;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketVersioningRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.mFA(model.mFA);
            this.versioningConfiguration(model.versioningConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public PutBucketVersioningRequest build() {
            return new PutBucketVersioningRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder mFA(String mFA) {
            this.mFA = mFA;
            return this;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String mFA() {
            return this.mFA;
        }

        public VersioningConfiguration versioningConfiguration() {
            return this.versioningConfiguration;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder mFA(String var1);

        public Builder versioningConfiguration(VersioningConfiguration var1);

        public Builder expectedBucketOwner(String var1);

        public PutBucketVersioningRequest build();
    }
}

