/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.RequestPayer;
import java.time.Instant;
import java.util.Objects;

public class HeadObjectRequest {
    String bucket;
    String ifMatch;
    Instant ifModifiedSince;
    String ifNoneMatch;
    Instant ifUnmodifiedSince;
    String key;
    String range;
    String versionId;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    RequestPayer requestPayer;
    Integer partNumber;
    String expectedBucketOwner;

    HeadObjectRequest() {
        this.bucket = "";
        this.ifMatch = "";
        this.ifModifiedSince = null;
        this.ifNoneMatch = "";
        this.ifUnmodifiedSince = null;
        this.key = "";
        this.range = "";
        this.versionId = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.requestPayer = null;
        this.partNumber = null;
        this.expectedBucketOwner = "";
    }

    protected HeadObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.key = builder.key;
        this.range = builder.range;
        this.versionId = builder.versionId;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.partNumber = builder.partNumber;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(HeadObjectRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof HeadObjectRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public Instant ifModifiedSince() {
        return this.ifModifiedSince;
    }

    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public Instant ifUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String key() {
        return this.key;
    }

    public String range() {
        return this.range;
    }

    public String versionId() {
        return this.versionId;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String ifMatch;
        Instant ifModifiedSince;
        String ifNoneMatch;
        Instant ifUnmodifiedSince;
        String key;
        String range;
        String versionId;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        RequestPayer requestPayer;
        Integer partNumber;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(HeadObjectRequest model) {
            this.bucket(model.bucket);
            this.ifMatch(model.ifMatch);
            this.ifModifiedSince(model.ifModifiedSince);
            this.ifNoneMatch(model.ifNoneMatch);
            this.ifUnmodifiedSince(model.ifUnmodifiedSince);
            this.key(model.key);
            this.range(model.range);
            this.versionId(model.versionId);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.partNumber(model.partNumber);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public HeadObjectRequest build() {
            return new HeadObjectRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public final Builder ifModifiedSince(Instant ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        @Override
        public final Builder ifUnmodifiedSince(Instant ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String ifMatch() {
            return this.ifMatch;
        }

        public Instant ifModifiedSince() {
            return this.ifModifiedSince;
        }

        public String ifNoneMatch() {
            return this.ifNoneMatch;
        }

        public Instant ifUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        public String key() {
            return this.key;
        }

        public String range() {
            return this.range;
        }

        public String versionId() {
            return this.versionId;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public Integer partNumber() {
            return this.partNumber;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder ifMatch(String var1);

        public Builder ifModifiedSince(Instant var1);

        public Builder ifNoneMatch(String var1);

        public Builder ifUnmodifiedSince(Instant var1);

        public Builder key(String var1);

        public Builder range(String var1);

        public Builder versionId(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder partNumber(Integer var1);

        public Builder expectedBucketOwner(String var1);

        public HeadObjectRequest build();
    }
}

