/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.MetadataDirective;
import com.amazonaws.s3.model.ObjectCannedACL;
import com.amazonaws.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.s3.model.ObjectLockMode;
import com.amazonaws.s3.model.RequestPayer;
import com.amazonaws.s3.model.ServerSideEncryption;
import com.amazonaws.s3.model.StorageClass;
import com.amazonaws.s3.model.TaggingDirective;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public class CopyObjectRequest {
    ObjectCannedACL aCL;
    String bucket;
    String cacheControl;
    String contentDisposition;
    String contentEncoding;
    String contentLanguage;
    String contentType;
    String copySource;
    String copySourceIfMatch;
    Instant copySourceIfModifiedSince;
    String copySourceIfNoneMatch;
    Instant copySourceIfUnmodifiedSince;
    Instant expires;
    String grantFullControl;
    String grantRead;
    String grantReadACP;
    String grantWriteACP;
    String key;
    Map<String, String> metadata;
    MetadataDirective metadataDirective;
    TaggingDirective taggingDirective;
    ServerSideEncryption serverSideEncryption;
    StorageClass storageClass;
    String websiteRedirectLocation;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    String sSEKMSKeyId;
    String sSEKMSEncryptionContext;
    Boolean bucketKeyEnabled;
    String copySourceSSECustomerAlgorithm;
    String copySourceSSECustomerKey;
    String copySourceSSECustomerKeyMD5;
    RequestPayer requestPayer;
    String tagging;
    ObjectLockMode objectLockMode;
    Instant objectLockRetainUntilDate;
    ObjectLockLegalHoldStatus objectLockLegalHoldStatus;
    String expectedBucketOwner;
    String expectedSourceBucketOwner;

    CopyObjectRequest() {
        this.aCL = null;
        this.bucket = "";
        this.cacheControl = "";
        this.contentDisposition = "";
        this.contentEncoding = "";
        this.contentLanguage = "";
        this.contentType = "";
        this.copySource = "";
        this.copySourceIfMatch = "";
        this.copySourceIfModifiedSince = null;
        this.copySourceIfNoneMatch = "";
        this.copySourceIfUnmodifiedSince = null;
        this.expires = null;
        this.grantFullControl = "";
        this.grantRead = "";
        this.grantReadACP = "";
        this.grantWriteACP = "";
        this.key = "";
        this.metadata = null;
        this.metadataDirective = null;
        this.taggingDirective = null;
        this.serverSideEncryption = null;
        this.storageClass = null;
        this.websiteRedirectLocation = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.sSEKMSKeyId = "";
        this.sSEKMSEncryptionContext = "";
        this.bucketKeyEnabled = null;
        this.copySourceSSECustomerAlgorithm = "";
        this.copySourceSSECustomerKey = "";
        this.copySourceSSECustomerKeyMD5 = "";
        this.requestPayer = null;
        this.tagging = "";
        this.objectLockMode = null;
        this.objectLockRetainUntilDate = null;
        this.objectLockLegalHoldStatus = null;
        this.expectedBucketOwner = "";
        this.expectedSourceBucketOwner = "";
    }

    protected CopyObjectRequest(BuilderImpl builder) {
        this.aCL = builder.aCL;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentType = builder.contentType;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.metadataDirective = builder.metadataDirective;
        this.taggingDirective = builder.taggingDirective;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.sSEKMSKeyId = builder.sSEKMSKeyId;
        this.sSEKMSEncryptionContext = builder.sSEKMSEncryptionContext;
        this.bucketKeyEnabled = builder.bucketKeyEnabled;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.tagging = builder.tagging;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
        this.objectLockLegalHoldStatus = builder.objectLockLegalHoldStatus;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.expectedSourceBucketOwner = builder.expectedSourceBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(CopyObjectRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof CopyObjectRequest;
    }

    public ObjectCannedACL aCL() {
        return this.aCL;
    }

    public String bucket() {
        return this.bucket;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public String copySource() {
        return this.copySource;
    }

    public String copySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public Instant copySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String copySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public Instant copySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public Instant expires() {
        return this.expires;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public MetadataDirective metadataDirective() {
        return this.metadataDirective;
    }

    public TaggingDirective taggingDirective() {
        return this.taggingDirective;
    }

    public ServerSideEncryption serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public String sSEKMSKeyId() {
        return this.sSEKMSKeyId;
    }

    public String sSEKMSEncryptionContext() {
        return this.sSEKMSEncryptionContext;
    }

    public Boolean bucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public String copySourceSSECustomerAlgorithm() {
        return this.copySourceSSECustomerAlgorithm;
    }

    public String copySourceSSECustomerKey() {
        return this.copySourceSSECustomerKey;
    }

    public String copySourceSSECustomerKeyMD5() {
        return this.copySourceSSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String tagging() {
        return this.tagging;
    }

    public ObjectLockMode objectLockMode() {
        return this.objectLockMode;
    }

    public Instant objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public String expectedSourceBucketOwner() {
        return this.expectedSourceBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        ObjectCannedACL aCL;
        String bucket;
        String cacheControl;
        String contentDisposition;
        String contentEncoding;
        String contentLanguage;
        String contentType;
        String copySource;
        String copySourceIfMatch;
        Instant copySourceIfModifiedSince;
        String copySourceIfNoneMatch;
        Instant copySourceIfUnmodifiedSince;
        Instant expires;
        String grantFullControl;
        String grantRead;
        String grantReadACP;
        String grantWriteACP;
        String key;
        Map<String, String> metadata;
        MetadataDirective metadataDirective;
        TaggingDirective taggingDirective;
        ServerSideEncryption serverSideEncryption;
        StorageClass storageClass;
        String websiteRedirectLocation;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        String sSEKMSKeyId;
        String sSEKMSEncryptionContext;
        Boolean bucketKeyEnabled;
        String copySourceSSECustomerAlgorithm;
        String copySourceSSECustomerKey;
        String copySourceSSECustomerKeyMD5;
        RequestPayer requestPayer;
        String tagging;
        ObjectLockMode objectLockMode;
        Instant objectLockRetainUntilDate;
        ObjectLockLegalHoldStatus objectLockLegalHoldStatus;
        String expectedBucketOwner;
        String expectedSourceBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(CopyObjectRequest model) {
            this.aCL(model.aCL);
            this.bucket(model.bucket);
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.contentType(model.contentType);
            this.copySource(model.copySource);
            this.copySourceIfMatch(model.copySourceIfMatch);
            this.copySourceIfModifiedSince(model.copySourceIfModifiedSince);
            this.copySourceIfNoneMatch(model.copySourceIfNoneMatch);
            this.copySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            this.expires(model.expires);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWriteACP(model.grantWriteACP);
            this.key(model.key);
            this.metadata(model.metadata);
            this.metadataDirective(model.metadataDirective);
            this.taggingDirective(model.taggingDirective);
            this.serverSideEncryption(model.serverSideEncryption);
            this.storageClass(model.storageClass);
            this.websiteRedirectLocation(model.websiteRedirectLocation);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.sSEKMSKeyId(model.sSEKMSKeyId);
            this.sSEKMSEncryptionContext(model.sSEKMSEncryptionContext);
            this.bucketKeyEnabled(model.bucketKeyEnabled);
            this.copySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            this.copySourceSSECustomerKey(model.copySourceSSECustomerKey);
            this.copySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.tagging(model.tagging);
            this.objectLockMode(model.objectLockMode);
            this.objectLockRetainUntilDate(model.objectLockRetainUntilDate);
            this.objectLockLegalHoldStatus(model.objectLockLegalHoldStatus);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.expectedSourceBucketOwner(model.expectedSourceBucketOwner);
        }

        @Override
        public CopyObjectRequest build() {
            return new CopyObjectRequest(this);
        }

        @Override
        public final Builder aCL(ObjectCannedACL aCL) {
            this.aCL = aCL;
            return this;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public final Builder metadataDirective(MetadataDirective metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        @Override
        public final Builder taggingDirective(TaggingDirective taggingDirective) {
            this.taggingDirective = taggingDirective;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder sSEKMSKeyId(String sSEKMSKeyId) {
            this.sSEKMSKeyId = sSEKMSKeyId;
            return this;
        }

        @Override
        public final Builder sSEKMSEncryptionContext(String sSEKMSEncryptionContext) {
            this.sSEKMSEncryptionContext = sSEKMSEncryptionContext;
            return this;
        }

        @Override
        public final Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        @Override
        public final Builder objectLockMode(ObjectLockMode objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        @Override
        public final Builder objectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder expectedSourceBucketOwner(String expectedSourceBucketOwner) {
            this.expectedSourceBucketOwner = expectedSourceBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public ObjectCannedACL aCL() {
            return this.aCL;
        }

        public String bucket() {
            return this.bucket;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String contentDisposition() {
            return this.contentDisposition;
        }

        public String contentEncoding() {
            return this.contentEncoding;
        }

        public String contentLanguage() {
            return this.contentLanguage;
        }

        public String contentType() {
            return this.contentType;
        }

        public String copySource() {
            return this.copySource;
        }

        public String copySourceIfMatch() {
            return this.copySourceIfMatch;
        }

        public Instant copySourceIfModifiedSince() {
            return this.copySourceIfModifiedSince;
        }

        public String copySourceIfNoneMatch() {
            return this.copySourceIfNoneMatch;
        }

        public Instant copySourceIfUnmodifiedSince() {
            return this.copySourceIfUnmodifiedSince;
        }

        public Instant expires() {
            return this.expires;
        }

        public String grantFullControl() {
            return this.grantFullControl;
        }

        public String grantRead() {
            return this.grantRead;
        }

        public String grantReadACP() {
            return this.grantReadACP;
        }

        public String grantWriteACP() {
            return this.grantWriteACP;
        }

        public String key() {
            return this.key;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        public MetadataDirective metadataDirective() {
            return this.metadataDirective;
        }

        public TaggingDirective taggingDirective() {
            return this.taggingDirective;
        }

        public ServerSideEncryption serverSideEncryption() {
            return this.serverSideEncryption;
        }

        public StorageClass storageClass() {
            return this.storageClass;
        }

        public String websiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public String sSEKMSKeyId() {
            return this.sSEKMSKeyId;
        }

        public String sSEKMSEncryptionContext() {
            return this.sSEKMSEncryptionContext;
        }

        public Boolean bucketKeyEnabled() {
            return this.bucketKeyEnabled;
        }

        public String copySourceSSECustomerAlgorithm() {
            return this.copySourceSSECustomerAlgorithm;
        }

        public String copySourceSSECustomerKey() {
            return this.copySourceSSECustomerKey;
        }

        public String copySourceSSECustomerKeyMD5() {
            return this.copySourceSSECustomerKeyMD5;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String tagging() {
            return this.tagging;
        }

        public ObjectLockMode objectLockMode() {
            return this.objectLockMode;
        }

        public Instant objectLockRetainUntilDate() {
            return this.objectLockRetainUntilDate;
        }

        public ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
            return this.objectLockLegalHoldStatus;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public String expectedSourceBucketOwner() {
            return this.expectedSourceBucketOwner;
        }
    }

    public static interface Builder {
        public Builder aCL(ObjectCannedACL var1);

        public Builder bucket(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentType(String var1);

        public Builder copySource(String var1);

        public Builder copySourceIfMatch(String var1);

        public Builder copySourceIfModifiedSince(Instant var1);

        public Builder copySourceIfNoneMatch(String var1);

        public Builder copySourceIfUnmodifiedSince(Instant var1);

        public Builder expires(Instant var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder metadataDirective(MetadataDirective var1);

        public Builder taggingDirective(TaggingDirective var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder storageClass(StorageClass var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder sSEKMSKeyId(String var1);

        public Builder sSEKMSEncryptionContext(String var1);

        public Builder bucketKeyEnabled(Boolean var1);

        public Builder copySourceSSECustomerAlgorithm(String var1);

        public Builder copySourceSSECustomerKey(String var1);

        public Builder copySourceSSECustomerKeyMD5(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder tagging(String var1);

        public Builder objectLockMode(ObjectLockMode var1);

        public Builder objectLockRetainUntilDate(Instant var1);

        public Builder objectLockLegalHoldStatus(ObjectLockLegalHoldStatus var1);

        public Builder expectedBucketOwner(String var1);

        public Builder expectedSourceBucketOwner(String var1);

        public CopyObjectRequest build();
    }
}

