/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3;

import com.amazonaws.s3.RequestDataSupplier;
import com.amazonaws.s3.ResponseDataConsumer;
import com.amazonaws.s3.model.GetObjectOutput;
import com.amazonaws.s3.model.GetObjectRequest;
import com.amazonaws.s3.model.PutObjectOutput;
import com.amazonaws.s3.model.PutObjectRequest;
import com.amazonaws.s3.model.RequestCharged;
import com.amazonaws.s3.model.ServerSideEncryption;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.s3.S3Client;
import software.amazon.awssdk.crt.s3.S3ClientOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequest;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;

public class S3NativeClient
implements AutoCloseable {
    private final S3Client s3Client;
    private final String signingRegion;

    public S3NativeClient(String signingRegion, ClientBootstrap clientBootstrap, CredentialsProvider credentialsProvider, long partSizeBytes, double targetThroughputGbps) {
        this.signingRegion = signingRegion;
        S3ClientOptions clientOptions = new S3ClientOptions().withClientBootstrap(clientBootstrap).withCredentialsProvider(credentialsProvider).withRegion(signingRegion).withPartSize(partSizeBytes).withThroughputTargetGbps(targetThroughputGbps);
        this.s3Client = new S3Client(clientOptions);
    }

    public CompletableFuture<GetObjectOutput> getObject(GetObjectRequest request, final ResponseDataConsumer dataHandler) {
        final CompletableFuture<GetObjectOutput> resultFuture = new CompletableFuture<GetObjectOutput>();
        final GetObjectOutput.Builder resultBuilder = GetObjectOutput.builder();
        S3MetaRequestResponseHandler responseHandler = new S3MetaRequestResponseHandler(){

            @Override
            public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
                for (int headerIndex = 0; headerIndex < headers.length; ++headerIndex) {
                    try {
                        S3NativeClient.this.populateGetObjectOutputHeader(resultBuilder, headers[headerIndex]);
                        continue;
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(new RuntimeException(String.format("Could not process response header {%s}: " + headers[headerIndex].getName(), new Object[0]), e));
                    }
                }
                dataHandler.onResponseHeaders(statusCode, headers);
            }

            @Override
            public int onResponseBody(byte[] bodyBytesIn, long objectRangeStart, long objectRangeEnd) {
                dataHandler.onResponseData(bodyBytesIn);
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFinished(int errorCode) {
                block10: {
                    block9: {
                        CrtRuntimeException ex = null;
                        try {
                            if (errorCode != 0) {
                                ex = new CrtRuntimeException(errorCode, CRT.awsErrorString(errorCode));
                                dataHandler.onException(ex);
                            } else {
                                dataHandler.onFinished();
                            }
                            if (ex == null) break block9;
                            resultFuture.completeExceptionally(ex);
                        }
                        catch (Exception exception) {
                            if (ex != null) {
                                resultFuture.completeExceptionally(ex);
                            } else {
                                resultFuture.complete(resultBuilder.build());
                            }
                        }
                        catch (Throwable throwable) {
                            if (ex != null) {
                                resultFuture.completeExceptionally(ex);
                            } else {
                                resultFuture.complete(resultBuilder.build());
                            }
                            throw throwable;
                        }
                        break block10;
                    }
                    resultFuture.complete(resultBuilder.build());
                }
            }
        };
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        headers.add(new HttpHeader("Host", request.bucket() + ".s3." + this.signingRegion + ".amazonaws.com"));
        this.populateGetObjectRequestHeaders(header -> headers.add((HttpHeader)header), request);
        StringBuilder keyString = new StringBuilder("/" + request.key());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        if (request.partNumber() != null) {
            requestParams.put("PartNumber", Integer.toString(request.partNumber()));
        }
        HttpRequest httpRequest = new HttpRequest("GET", keyString.toString(), headers.toArray(new HttpHeader[0]), null);
        S3MetaRequestOptions metaRequestOptions = new S3MetaRequestOptions().withMetaRequestType(S3MetaRequestOptions.MetaRequestType.GET_OBJECT).withHttpRequest(httpRequest).withResponseHandler(responseHandler);
        try (S3MetaRequest metaRequest = this.s3Client.makeMetaRequest(metaRequestOptions);){
            CompletableFuture<GetObjectOutput> completableFuture = resultFuture;
            return completableFuture;
        }
    }

    public CompletableFuture<PutObjectOutput> putObject(final PutObjectRequest request, final RequestDataSupplier requestDataSupplier) {
        final CompletableFuture<PutObjectOutput> resultFuture = new CompletableFuture<PutObjectOutput>();
        final PutObjectOutput.Builder resultBuilder = PutObjectOutput.builder();
        HttpRequestBodyStream payloadStream = new HttpRequestBodyStream(){

            @Override
            public boolean sendRequestBody(ByteBuffer outBuffer) {
                try {
                    if (outBuffer.hasArray()) {
                        return requestDataSupplier.getRequestBytes(outBuffer.array());
                    }
                    byte[] buffer = new byte[outBuffer.capacity()];
                    boolean returnFlag = requestDataSupplier.getRequestBytes(buffer);
                    outBuffer.put(buffer);
                    return returnFlag;
                }
                catch (Exception e) {
                    resultFuture.completeExceptionally(e);
                    return true;
                }
            }

            @Override
            public boolean resetPosition() {
                try {
                    return requestDataSupplier.resetPosition();
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public long getLength() {
                return request.contentLength();
            }
        };
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        headers.add(new HttpHeader("Host", request.bucket() + ".s3." + this.signingRegion + ".amazonaws.com"));
        this.populatePutObjectRequestHeaders(header -> headers.add((HttpHeader)header), request);
        StringBuilder keyString = new StringBuilder("/" + request.key());
        HttpRequest httpRequest = new HttpRequest("PUT", keyString.toString(), headers.toArray(new HttpHeader[0]), payloadStream);
        S3MetaRequestResponseHandler responseHandler = new S3MetaRequestResponseHandler(){

            @Override
            public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
                for (int headerIndex = 0; headerIndex < headers.length; ++headerIndex) {
                    try {
                        S3NativeClient.this.populatePutObjectOutputHeader(resultBuilder, headers[headerIndex]);
                        continue;
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(new RuntimeException(String.format("Could not process response header {%s}: " + headers[headerIndex].getName(), new Object[0]), e));
                    }
                }
                requestDataSupplier.onResponseHeaders(statusCode, headers);
            }

            @Override
            public int onResponseBody(byte[] bodyBytesIn, long objectRangeStart, long objectRangeEnd) {
                return 0;
            }

            @Override
            public void onFinished(int errorCode) {
                if (errorCode == 0) {
                    resultFuture.complete(resultBuilder.build());
                } else {
                    resultFuture.completeExceptionally(new CrtRuntimeException(errorCode, CRT.awsErrorString(errorCode)));
                }
            }
        };
        S3MetaRequestOptions metaRequestOptions = new S3MetaRequestOptions().withMetaRequestType(S3MetaRequestOptions.MetaRequestType.PUT_OBJECT).withHttpRequest(httpRequest).withResponseHandler(responseHandler);
        try (S3MetaRequest metaRequest = this.s3Client.makeMetaRequest(metaRequestOptions);){
            CompletableFuture<PutObjectOutput> completableFuture = resultFuture;
            return completableFuture;
        }
    }

    @Override
    public void close() {
        if (this.s3Client != null) {
            this.s3Client.close();
        }
    }

    protected void populateGetObjectRequestHeaders(Consumer<HttpHeader> headerConsumer, GetObjectRequest request) {
        if (request.ifMatch() != null) {
            headerConsumer.accept(new HttpHeader("If-Match", request.ifMatch()));
        }
        if (request.ifMatch() != null) {
            headerConsumer.accept(new HttpHeader("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(request.ifModifiedSince())));
        }
        if (request.ifNoneMatch() != null) {
            headerConsumer.accept(new HttpHeader("If-None-Match", request.ifNoneMatch()));
        }
        if (request.ifUnmodifiedSince() != null) {
            headerConsumer.accept(new HttpHeader("If-Unmodified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(request.ifUnmodifiedSince())));
        }
        if (request.range() != null) {
            headerConsumer.accept(new HttpHeader("Range", request.range()));
        }
        if (request.sSECustomerAlgorithm() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-algorithm", request.sSECustomerAlgorithm()));
        }
        if (request.sSECustomerKey() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-key", request.sSECustomerKey()));
        }
        if (request.sSECustomerKeyMD5() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-key-MD5", request.sSECustomerKeyMD5()));
        }
        if (request.requestPayer() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-request-payer", request.requestPayer().name()));
        }
        if (request.expectedBucketOwner() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-expected-bucket-owner", request.expectedBucketOwner()));
        }
    }

    protected void populateGetObjectOutputHeader(GetObjectOutput.Builder builder, HttpHeader header) {
        if (!"x-amz-id-2".equalsIgnoreCase(header.getName()) && !"x-amz-request-id".equalsIgnoreCase(header.getName())) {
            if ("Last-Modified".equalsIgnoreCase(header.getName())) {
                builder.lastModified(DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)header.getValue(), Instant::from));
            } else if ("ETag".equalsIgnoreCase(header.getName())) {
                builder.eTag(header.getValue());
            } else if ("x-amz-version-id".equalsIgnoreCase(header.getName())) {
                builder.versionId(header.getValue());
            } else if ("Accept-Ranges".equalsIgnoreCase(header.getName())) {
                builder.acceptRanges(header.getValue());
            } else if ("Content-Type".equalsIgnoreCase(header.getName())) {
                builder.contentType(header.getValue());
            } else if ("Content-Length".equalsIgnoreCase(header.getName())) {
                builder.contentLength(Long.parseLong(header.getValue()));
            }
        }
    }

    protected void populatePutObjectRequestHeaders(Consumer<HttpHeader> headerConsumer, PutObjectRequest request) {
        if (request.aCL() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-acl", request.aCL().name()));
        }
        if (request.cacheControl() != null) {
            headerConsumer.accept(new HttpHeader("Cache-Control", request.cacheControl()));
        }
        if (request.contentDisposition() != null) {
            headerConsumer.accept(new HttpHeader("Content-Disposition", request.contentDisposition()));
        }
        if (request.contentEncoding() != null) {
            headerConsumer.accept(new HttpHeader("Content-Encoding", request.contentEncoding()));
        }
        if (request.contentLanguage() != null) {
            headerConsumer.accept(new HttpHeader("Content-Language", request.contentLanguage()));
        }
        if (request.contentLength() != null) {
            headerConsumer.accept(new HttpHeader("Content-Length", Long.toString(request.contentLength())));
        }
        if (request.contentMD5() != null) {
            headerConsumer.accept(new HttpHeader("Content-MD5", request.contentMD5()));
        }
        if (request.contentType() != null) {
            headerConsumer.accept(new HttpHeader("Content-Type", request.contentType()));
        }
        if (request.expires() != null) {
            headerConsumer.accept(new HttpHeader("Expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(request.expires())));
        }
        if (request.grantFullControl() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-grant-full-control", request.grantFullControl()));
        }
        if (request.grantRead() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-grant-read", request.grantRead()));
        }
        if (request.grantReadACP() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-grant-read-acp", request.grantReadACP()));
        }
        if (request.grantWriteACP() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-grant-write-acp", request.grantWriteACP()));
        }
        if (request.serverSideEncryption() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption", request.serverSideEncryption().name()));
        }
        if (request.storageClass() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-storage-class", request.storageClass().name()));
        }
        if (request.websiteRedirectLocation() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-website-redirect-location", request.websiteRedirectLocation()));
        }
        if (request.sSECustomerAlgorithm() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-algorithm", request.sSECustomerAlgorithm()));
        }
        if (request.sSECustomerKey() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-key", request.sSECustomerKey()));
        }
        if (request.sSECustomerKeyMD5() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-customer-key-MD5", request.sSECustomerKeyMD5()));
        }
        if (request.sSEKMSKeyId() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-aws-kms-key-id", request.sSEKMSKeyId()));
        }
        if (request.sSEKMSEncryptionContext() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-context", request.sSEKMSEncryptionContext()));
        }
        if (request.bucketKeyEnabled() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-server-side-encryption-bucket-key-enabled", Boolean.toString(request.bucketKeyEnabled())));
        }
        if (request.requestPayer() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-request-payer", request.requestPayer().name()));
        }
        if (request.tagging() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-tagging", request.tagging()));
        }
        if (request.objectLockMode() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-object-lock-mode", request.objectLockMode().name()));
        }
        if (request.objectLockRetainUntilDate() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-object-lock-retain-until-date", DateTimeFormatter.RFC_1123_DATE_TIME.format(request.objectLockRetainUntilDate())));
        }
        if (request.objectLockLegalHoldStatus() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-object-lock-legal-hold", request.objectLockLegalHoldStatus().name()));
        }
        if (request.expectedBucketOwner() != null) {
            headerConsumer.accept(new HttpHeader("x-amz-expected-bucket-owner", request.expectedBucketOwner()));
        }
    }

    protected void populatePutObjectOutputHeader(PutObjectOutput.Builder builder, HttpHeader header) {
        if (!"xamz-id-2".equalsIgnoreCase(header.getName()) && !"x-amz-request-id".equalsIgnoreCase(header.getName())) {
            if ("x-amz-version-id".equalsIgnoreCase(header.getName())) {
                builder.versionId(header.getValue());
            } else if ("ETag".equalsIgnoreCase(header.getName())) {
                builder.eTag(header.getValue());
            } else if ("x-amz-expiration".equalsIgnoreCase(header.getName())) {
                builder.expiration(header.getValue());
            } else if ("x-amz-server-side-encryption".equalsIgnoreCase(header.getName())) {
                builder.serverSideEncryption(ServerSideEncryption.fromValue(header.getValue()));
            } else if ("x-amz-server-side-encryption-aws-kms-key-id".equalsIgnoreCase(header.getName())) {
                builder.sSEKMSKeyId(header.getValue());
            } else if ("x-amz-server-side-encryption-bucket-key-enabled".equalsIgnoreCase(header.getName())) {
                builder.bucketKeyEnabled(Boolean.parseBoolean(header.getValue()));
            } else if ("x-amz-request-charged".equalsIgnoreCase(header.getName())) {
                builder.requestCharged(RequestCharged.fromValue(header.getValue()));
            }
        }
    }
}

