/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter;

public class HttpClientConnection
extends CrtResource {
    private final HttpClientConnectionManager manager;

    protected HttpClientConnection(HttpClientConnectionManager manager, long connection) {
        this.acquireNativeHandle(connection);
        this.addReferenceTo(manager);
        this.manager = manager;
    }

    public HttpStream makeRequest(HttpRequest request, HttpStreamResponseHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed, can't make requests on it.");
        }
        HttpStream stream = HttpClientConnection.httpClientConnectionMakeRequest(this.getNativeHandle(), request.marshalForJni(), request.getBodyStream(), new HttpStreamResponseHandlerNativeAdapter(streamHandler));
        if (stream == null || stream.isNull()) {
            throw new CrtRuntimeException(CRT.awsLastError());
        }
        return stream;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            this.manager.releaseConnectionPointer(this.getNativeHandle());
        }
    }

    public void shutdown() {
        HttpClientConnection.httpClientConnectionShutdown(this.getNativeHandle());
    }

    private static native HttpStream httpClientConnectionMakeRequest(long var0, byte[] var2, HttpRequestBodyStream var3, HttpStreamResponseHandlerNativeAdapter var4) throws CrtRuntimeException;

    private static native void httpClientConnectionShutdown(long var0) throws CrtRuntimeException;
}

