/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.RequestPayer;
import java.time.Instant;
import java.util.Objects;

public class UploadPartCopyRequest {
    String bucket;
    String copySource;
    String copySourceIfMatch;
    Instant copySourceIfModifiedSince;
    String copySourceIfNoneMatch;
    Instant copySourceIfUnmodifiedSince;
    String copySourceRange;
    String key;
    Integer partNumber;
    String uploadId;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    String copySourceSSECustomerAlgorithm;
    String copySourceSSECustomerKey;
    String copySourceSSECustomerKeyMD5;
    RequestPayer requestPayer;
    String expectedBucketOwner;
    String expectedSourceBucketOwner;

    UploadPartCopyRequest() {
        this.bucket = "";
        this.copySource = "";
        this.copySourceIfMatch = "";
        this.copySourceIfModifiedSince = null;
        this.copySourceIfNoneMatch = "";
        this.copySourceIfUnmodifiedSince = null;
        this.copySourceRange = "";
        this.key = "";
        this.partNumber = null;
        this.uploadId = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.copySourceSSECustomerAlgorithm = "";
        this.copySourceSSECustomerKey = "";
        this.copySourceSSECustomerKeyMD5 = "";
        this.requestPayer = null;
        this.expectedBucketOwner = "";
        this.expectedSourceBucketOwner = "";
    }

    protected UploadPartCopyRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.copySourceRange = builder.copySourceRange;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.expectedSourceBucketOwner = builder.expectedSourceBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(UploadPartCopyRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof UploadPartCopyRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String copySource() {
        return this.copySource;
    }

    public String copySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public Instant copySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String copySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public Instant copySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public String copySourceRange() {
        return this.copySourceRange;
    }

    public String key() {
        return this.key;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public String copySourceSSECustomerAlgorithm() {
        return this.copySourceSSECustomerAlgorithm;
    }

    public String copySourceSSECustomerKey() {
        return this.copySourceSSECustomerKey;
    }

    public String copySourceSSECustomerKeyMD5() {
        return this.copySourceSSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public String expectedSourceBucketOwner() {
        return this.expectedSourceBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String copySource;
        String copySourceIfMatch;
        Instant copySourceIfModifiedSince;
        String copySourceIfNoneMatch;
        Instant copySourceIfUnmodifiedSince;
        String copySourceRange;
        String key;
        Integer partNumber;
        String uploadId;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        String copySourceSSECustomerAlgorithm;
        String copySourceSSECustomerKey;
        String copySourceSSECustomerKeyMD5;
        RequestPayer requestPayer;
        String expectedBucketOwner;
        String expectedSourceBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(UploadPartCopyRequest model) {
            this.bucket(model.bucket);
            this.copySource(model.copySource);
            this.copySourceIfMatch(model.copySourceIfMatch);
            this.copySourceIfModifiedSince(model.copySourceIfModifiedSince);
            this.copySourceIfNoneMatch(model.copySourceIfNoneMatch);
            this.copySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            this.copySourceRange(model.copySourceRange);
            this.key(model.key);
            this.partNumber(model.partNumber);
            this.uploadId(model.uploadId);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.copySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            this.copySourceSSECustomerKey(model.copySourceSSECustomerKey);
            this.copySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.expectedSourceBucketOwner(model.expectedSourceBucketOwner);
        }

        @Override
        public UploadPartCopyRequest build() {
            return new UploadPartCopyRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        @Override
        public final Builder copySourceRange(String copySourceRange) {
            this.copySourceRange = copySourceRange;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder expectedSourceBucketOwner(String expectedSourceBucketOwner) {
            this.expectedSourceBucketOwner = expectedSourceBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String copySource() {
            return this.copySource;
        }

        public String copySourceIfMatch() {
            return this.copySourceIfMatch;
        }

        public Instant copySourceIfModifiedSince() {
            return this.copySourceIfModifiedSince;
        }

        public String copySourceIfNoneMatch() {
            return this.copySourceIfNoneMatch;
        }

        public Instant copySourceIfUnmodifiedSince() {
            return this.copySourceIfUnmodifiedSince;
        }

        public String copySourceRange() {
            return this.copySourceRange;
        }

        public String key() {
            return this.key;
        }

        public Integer partNumber() {
            return this.partNumber;
        }

        public String uploadId() {
            return this.uploadId;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public String copySourceSSECustomerAlgorithm() {
            return this.copySourceSSECustomerAlgorithm;
        }

        public String copySourceSSECustomerKey() {
            return this.copySourceSSECustomerKey;
        }

        public String copySourceSSECustomerKeyMD5() {
            return this.copySourceSSECustomerKeyMD5;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public String expectedSourceBucketOwner() {
            return this.expectedSourceBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder copySource(String var1);

        public Builder copySourceIfMatch(String var1);

        public Builder copySourceIfModifiedSince(Instant var1);

        public Builder copySourceIfNoneMatch(String var1);

        public Builder copySourceIfUnmodifiedSince(Instant var1);

        public Builder copySourceRange(String var1);

        public Builder key(String var1);

        public Builder partNumber(Integer var1);

        public Builder uploadId(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder copySourceSSECustomerAlgorithm(String var1);

        public Builder copySourceSSECustomerKey(String var1);

        public Builder copySourceSSECustomerKeyMD5(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder expectedBucketOwner(String var1);

        public Builder expectedSourceBucketOwner(String var1);

        public UploadPartCopyRequest build();
    }
}

