/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ExpressionType;
import com.amazonaws.s3.model.InputSerialization;
import com.amazonaws.s3.model.OutputSerialization;
import com.amazonaws.s3.model.RequestProgress;
import com.amazonaws.s3.model.ScanRange;
import java.util.Objects;

public class SelectObjectContentRequest {
    String bucket;
    String key;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    String expression;
    ExpressionType expressionType;
    RequestProgress requestProgress;
    InputSerialization inputSerialization;
    OutputSerialization outputSerialization;
    ScanRange scanRange;
    String expectedBucketOwner;

    SelectObjectContentRequest() {
        this.bucket = "";
        this.key = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.expression = "";
        this.expressionType = null;
        this.requestProgress = null;
        this.inputSerialization = null;
        this.outputSerialization = null;
        this.scanRange = null;
        this.expectedBucketOwner = "";
    }

    protected SelectObjectContentRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.expression = builder.expression;
        this.expressionType = builder.expressionType;
        this.requestProgress = builder.requestProgress;
        this.inputSerialization = builder.inputSerialization;
        this.outputSerialization = builder.outputSerialization;
        this.scanRange = builder.scanRange;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(SelectObjectContentRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof SelectObjectContentRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public String expression() {
        return this.expression;
    }

    public ExpressionType expressionType() {
        return this.expressionType;
    }

    public RequestProgress requestProgress() {
        return this.requestProgress;
    }

    public InputSerialization inputSerialization() {
        return this.inputSerialization;
    }

    public OutputSerialization outputSerialization() {
        return this.outputSerialization;
    }

    public ScanRange scanRange() {
        return this.scanRange;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String key;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        String expression;
        ExpressionType expressionType;
        RequestProgress requestProgress;
        InputSerialization inputSerialization;
        OutputSerialization outputSerialization;
        ScanRange scanRange;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(SelectObjectContentRequest model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.expression(model.expression);
            this.expressionType(model.expressionType);
            this.requestProgress(model.requestProgress);
            this.inputSerialization(model.inputSerialization);
            this.outputSerialization(model.outputSerialization);
            this.scanRange(model.scanRange);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public SelectObjectContentRequest build() {
            return new SelectObjectContentRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        @Override
        public final Builder requestProgress(RequestProgress requestProgress) {
            this.requestProgress = requestProgress;
            return this;
        }

        @Override
        public final Builder inputSerialization(InputSerialization inputSerialization) {
            this.inputSerialization = inputSerialization;
            return this;
        }

        @Override
        public final Builder outputSerialization(OutputSerialization outputSerialization) {
            this.outputSerialization = outputSerialization;
            return this;
        }

        @Override
        public final Builder scanRange(ScanRange scanRange) {
            this.scanRange = scanRange;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String key() {
            return this.key;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public String expression() {
            return this.expression;
        }

        public ExpressionType expressionType() {
            return this.expressionType;
        }

        public RequestProgress requestProgress() {
            return this.requestProgress;
        }

        public InputSerialization inputSerialization() {
            return this.inputSerialization;
        }

        public OutputSerialization outputSerialization() {
            return this.outputSerialization;
        }

        public ScanRange scanRange() {
            return this.scanRange;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder expression(String var1);

        public Builder expressionType(ExpressionType var1);

        public Builder requestProgress(RequestProgress var1);

        public Builder inputSerialization(InputSerialization var1);

        public Builder outputSerialization(OutputSerialization var1);

        public Builder scanRange(ScanRange var1);

        public Builder expectedBucketOwner(String var1);

        public SelectObjectContentRequest build();
    }
}

