/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ReplicationConfiguration;
import java.util.Objects;

public class PutBucketReplicationRequest {
    String bucket;
    String contentMD5;
    ReplicationConfiguration replicationConfiguration;
    String token;
    String expectedBucketOwner;

    PutBucketReplicationRequest() {
        this.bucket = "";
        this.contentMD5 = "";
        this.replicationConfiguration = null;
        this.token = "";
        this.expectedBucketOwner = "";
    }

    protected PutBucketReplicationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.replicationConfiguration = builder.replicationConfiguration;
        this.token = builder.token;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketReplicationRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketReplicationRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public ReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public String token() {
        return this.token;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String contentMD5;
        ReplicationConfiguration replicationConfiguration;
        String token;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketReplicationRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.replicationConfiguration(model.replicationConfiguration);
            this.token(model.token);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public PutBucketReplicationRequest build() {
            return new PutBucketReplicationRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public ReplicationConfiguration replicationConfiguration() {
            return this.replicationConfiguration;
        }

        public String token() {
            return this.token;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder replicationConfiguration(ReplicationConfiguration var1);

        public Builder token(String var1);

        public Builder expectedBucketOwner(String var1);

        public PutBucketReplicationRequest build();
    }
}

