/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.EncodingType;
import com.amazonaws.s3.model.RequestPayer;
import java.util.Objects;

public class ListObjectsRequest {
    String bucket;
    String delimiter;
    EncodingType encodingType;
    String marker;
    Integer maxKeys;
    String prefix;
    RequestPayer requestPayer;
    String expectedBucketOwner;

    ListObjectsRequest() {
        this.bucket = "";
        this.delimiter = "";
        this.encodingType = null;
        this.marker = "";
        this.maxKeys = null;
        this.prefix = "";
        this.requestPayer = null;
        this.expectedBucketOwner = "";
    }

    protected ListObjectsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.marker = builder.marker;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.requestPayer = builder.requestPayer;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(ListObjectsRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof ListObjectsRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public EncodingType encodingType() {
        return this.encodingType;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public String prefix() {
        return this.prefix;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String delimiter;
        EncodingType encodingType;
        String marker;
        Integer maxKeys;
        String prefix;
        RequestPayer requestPayer;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(ListObjectsRequest model) {
            this.bucket(model.bucket);
            this.delimiter(model.delimiter);
            this.encodingType(model.encodingType);
            this.marker(model.marker);
            this.maxKeys(model.maxKeys);
            this.prefix(model.prefix);
            this.requestPayer(model.requestPayer);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public ListObjectsRequest build() {
            return new ListObjectsRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String delimiter() {
            return this.delimiter;
        }

        public EncodingType encodingType() {
            return this.encodingType;
        }

        public String marker() {
            return this.marker;
        }

        public Integer maxKeys() {
            return this.maxKeys;
        }

        public String prefix() {
            return this.prefix;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder delimiter(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder marker(String var1);

        public Builder maxKeys(Integer var1);

        public Builder prefix(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder expectedBucketOwner(String var1);

        public ListObjectsRequest build();
    }
}

