/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.RequestPayer;
import java.util.Objects;

public class DeleteObjectRequest {
    String bucket;
    String key;
    String mFA;
    String versionId;
    RequestPayer requestPayer;
    Boolean bypassGovernanceRetention;
    String expectedBucketOwner;

    DeleteObjectRequest() {
        this.bucket = "";
        this.key = "";
        this.mFA = "";
        this.versionId = "";
        this.requestPayer = null;
        this.bypassGovernanceRetention = null;
        this.expectedBucketOwner = "";
    }

    protected DeleteObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.mFA = builder.mFA;
        this.versionId = builder.versionId;
        this.requestPayer = builder.requestPayer;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(DeleteObjectRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof DeleteObjectRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String mFA() {
        return this.mFA;
    }

    public String versionId() {
        return this.versionId;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public Boolean bypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String key;
        String mFA;
        String versionId;
        RequestPayer requestPayer;
        Boolean bypassGovernanceRetention;
        String expectedBucketOwner;

        protected BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectRequest model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.mFA(model.mFA);
            this.versionId(model.versionId);
            this.requestPayer(model.requestPayer);
            this.bypassGovernanceRetention(model.bypassGovernanceRetention);
            this.expectedBucketOwner(model.expectedBucketOwner);
        }

        @Override
        public DeleteObjectRequest build() {
            return new DeleteObjectRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder mFA(String mFA) {
            this.mFA = mFA;
            return this;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String key() {
            return this.key;
        }

        public String mFA() {
            return this.mFA;
        }

        public String versionId() {
            return this.versionId;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public Boolean bypassGovernanceRetention() {
            return this.bypassGovernanceRetention;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder mFA(String var1);

        public Builder versionId(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder bypassGovernanceRetention(Boolean var1);

        public Builder expectedBucketOwner(String var1);

        public DeleteObjectRequest build();
    }
}

