/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.PaymentOption;
import software.amazon.awssdk.services.costoptimizationhub.model.Term;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreferredCommitment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreferredCommitment> {
    private static final SdkField<String> TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("term").getter(PreferredCommitment.getter(PreferredCommitment::termAsString)).setter(PreferredCommitment.setter(Builder::term)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("paymentOption").getter(PreferredCommitment.getter(PreferredCommitment::paymentOptionAsString)).setter(PreferredCommitment.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERM_FIELD, PAYMENT_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreferredCommitment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String term;
    private final String paymentOption;

    private PreferredCommitment(BuilderImpl builder) {
        this.term = builder.term;
        this.paymentOption = builder.paymentOption;
    }

    public final Term term() {
        return Term.fromValue(this.term);
    }

    public final String termAsString() {
        return this.term;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.termAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreferredCommitment)) {
            return false;
        }
        PreferredCommitment other = (PreferredCommitment)obj;
        return Objects.equals(this.termAsString(), other.termAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PreferredCommitment").add("Term", (Object)this.termAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "term": {
                return Optional.ofNullable(clazz.cast(this.termAsString()));
            }
            case "paymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("term", TERM_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreferredCommitment, T> g) {
        return obj -> g.apply((PreferredCommitment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String term;
        private String paymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(PreferredCommitment model) {
            this.term(model.term);
            this.paymentOption(model.paymentOption);
        }

        public final String getTerm() {
            return this.term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        @Override
        public final Builder term(Term term) {
            this.term(term == null ? null : term.toString());
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public PreferredCommitment build() {
            return new PreferredCommitment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreferredCommitment> {
        public Builder term(String var1);

        public Builder term(Term var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);
    }
}

