/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.EcsServiceConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceCostCalculation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsService> {
    private static final SdkField<EcsServiceConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(EcsService.getter(EcsService::configuration)).setter(EcsService.setter(Builder::configuration)).constructor(EcsServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ResourceCostCalculation> COST_CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costCalculation").getter(EcsService.getter(EcsService::costCalculation)).setter(EcsService.setter(Builder::costCalculation)).constructor(ResourceCostCalculation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, COST_CALCULATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EcsServiceConfiguration configuration;
    private final ResourceCostCalculation costCalculation;

    private EcsService(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    public final EcsServiceConfiguration configuration() {
        return this.configuration;
    }

    public final ResourceCostCalculation costCalculation() {
        return this.costCalculation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCalculation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsService)) {
            return false;
        }
        EcsService other = (EcsService)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.costCalculation(), other.costCalculation());
    }

    public final String toString() {
        return ToString.builder((String)"EcsService").add("Configuration", (Object)this.configuration()).add("CostCalculation", (Object)this.costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "costCalculation": {
                return Optional.ofNullable(clazz.cast(this.costCalculation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("costCalculation", COST_CALCULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsService, T> g) {
        return obj -> g.apply((EcsService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EcsServiceConfiguration configuration;
        private ResourceCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsService model) {
            this.configuration(model.configuration);
            this.costCalculation(model.costCalculation);
        }

        public final EcsServiceConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(EcsServiceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(EcsServiceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ResourceCostCalculation.Builder getCostCalculation() {
            return this.costCalculation != null ? this.costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ResourceCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ResourceCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        public EcsService build() {
            return new EcsService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsService> {
        public Builder configuration(EcsServiceConfiguration var1);

        default public Builder configuration(Consumer<EcsServiceConfiguration.Builder> configuration) {
            return this.configuration((EcsServiceConfiguration)((EcsServiceConfiguration.Builder)EcsServiceConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder costCalculation(ResourceCostCalculation var1);

        default public Builder costCalculation(Consumer<ResourceCostCalculation.Builder> costCalculation) {
            return this.costCalculation((ResourceCostCalculation)((ResourceCostCalculation.Builder)ResourceCostCalculation.builder().applyMutation(costCalculation)).build());
        }
    }
}

