/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.ElastiCacheReservedInstancesConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.ReservedInstancesCostCalculation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElastiCacheReservedInstances
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElastiCacheReservedInstances> {
    private static final SdkField<ElastiCacheReservedInstancesConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ElastiCacheReservedInstances.getter(ElastiCacheReservedInstances::configuration)).setter(ElastiCacheReservedInstances.setter(Builder::configuration)).constructor(ElastiCacheReservedInstancesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ReservedInstancesCostCalculation> COST_CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costCalculation").getter(ElastiCacheReservedInstances.getter(ElastiCacheReservedInstances::costCalculation)).setter(ElastiCacheReservedInstances.setter(Builder::costCalculation)).constructor(ReservedInstancesCostCalculation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, COST_CALCULATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("costCalculation", COST_CALCULATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ElastiCacheReservedInstancesConfiguration configuration;
    private final ReservedInstancesCostCalculation costCalculation;

    private ElastiCacheReservedInstances(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    public final ElastiCacheReservedInstancesConfiguration configuration() {
        return this.configuration;
    }

    public final ReservedInstancesCostCalculation costCalculation() {
        return this.costCalculation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCalculation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElastiCacheReservedInstances)) {
            return false;
        }
        ElastiCacheReservedInstances other = (ElastiCacheReservedInstances)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.costCalculation(), other.costCalculation());
    }

    public final String toString() {
        return ToString.builder((String)"ElastiCacheReservedInstances").add("Configuration", (Object)this.configuration()).add("CostCalculation", (Object)this.costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "costCalculation": {
                return Optional.ofNullable(clazz.cast(this.costCalculation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ElastiCacheReservedInstances, T> g) {
        return obj -> g.apply((ElastiCacheReservedInstances)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ElastiCacheReservedInstancesConfiguration configuration;
        private ReservedInstancesCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(ElastiCacheReservedInstances model) {
            this.configuration(model.configuration);
            this.costCalculation(model.costCalculation);
        }

        public final ElastiCacheReservedInstancesConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ElastiCacheReservedInstancesConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ElastiCacheReservedInstancesConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ReservedInstancesCostCalculation.Builder getCostCalculation() {
            return this.costCalculation != null ? this.costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ReservedInstancesCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ReservedInstancesCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        public ElastiCacheReservedInstances build() {
            return new ElastiCacheReservedInstances(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElastiCacheReservedInstances> {
        public Builder configuration(ElastiCacheReservedInstancesConfiguration var1);

        default public Builder configuration(Consumer<ElastiCacheReservedInstancesConfiguration.Builder> configuration) {
            return this.configuration((ElastiCacheReservedInstancesConfiguration)((ElastiCacheReservedInstancesConfiguration.Builder)ElastiCacheReservedInstancesConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder costCalculation(ReservedInstancesCostCalculation var1);

        default public Builder costCalculation(Consumer<ReservedInstancesCostCalculation.Builder> costCalculation) {
            return this.costCalculation((ReservedInstancesCostCalculation)((ReservedInstancesCostCalculation.Builder)ReservedInstancesCostCalculation.builder().applyMutation(costCalculation)).build());
        }
    }
}

