/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2ReservedInstancesConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.ReservedInstancesCostCalculation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2ReservedInstances
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2ReservedInstances> {
    private static final SdkField<Ec2ReservedInstancesConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(Ec2ReservedInstances.getter(Ec2ReservedInstances::configuration)).setter(Ec2ReservedInstances.setter(Builder::configuration)).constructor(Ec2ReservedInstancesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ReservedInstancesCostCalculation> COST_CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costCalculation").getter(Ec2ReservedInstances.getter(Ec2ReservedInstances::costCalculation)).setter(Ec2ReservedInstances.setter(Builder::costCalculation)).constructor(ReservedInstancesCostCalculation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, COST_CALCULATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("costCalculation", COST_CALCULATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Ec2ReservedInstancesConfiguration configuration;
    private final ReservedInstancesCostCalculation costCalculation;

    private Ec2ReservedInstances(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    public final Ec2ReservedInstancesConfiguration configuration() {
        return this.configuration;
    }

    public final ReservedInstancesCostCalculation costCalculation() {
        return this.costCalculation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCalculation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2ReservedInstances)) {
            return false;
        }
        Ec2ReservedInstances other = (Ec2ReservedInstances)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.costCalculation(), other.costCalculation());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2ReservedInstances").add("Configuration", (Object)this.configuration()).add("CostCalculation", (Object)this.costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "costCalculation": {
                return Optional.ofNullable(clazz.cast(this.costCalculation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Ec2ReservedInstances, T> g) {
        return obj -> g.apply((Ec2ReservedInstances)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Ec2ReservedInstancesConfiguration configuration;
        private ReservedInstancesCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2ReservedInstances model) {
            this.configuration(model.configuration);
            this.costCalculation(model.costCalculation);
        }

        public final Ec2ReservedInstancesConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(Ec2ReservedInstancesConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Ec2ReservedInstancesConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ReservedInstancesCostCalculation.Builder getCostCalculation() {
            return this.costCalculation != null ? this.costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ReservedInstancesCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ReservedInstancesCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        public Ec2ReservedInstances build() {
            return new Ec2ReservedInstances(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2ReservedInstances> {
        public Builder configuration(Ec2ReservedInstancesConfiguration var1);

        default public Builder configuration(Consumer<Ec2ReservedInstancesConfiguration.Builder> configuration) {
            return this.configuration((Ec2ReservedInstancesConfiguration)((Ec2ReservedInstancesConfiguration.Builder)Ec2ReservedInstancesConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder costCalculation(ReservedInstancesCostCalculation var1);

        default public Builder costCalculation(Consumer<ReservedInstancesCostCalculation.Builder> costCalculation) {
            return this.costCalculation((ReservedInstancesCostCalculation)((ReservedInstancesCostCalculation.Builder)ReservedInstancesCostCalculation.builder().applyMutation(costCalculation)).build());
        }
    }
}

