/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.BlockStoragePerformanceConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.StorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsVolumeConfiguration> {
    private static final SdkField<StorageConfiguration> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storage").getter(EbsVolumeConfiguration.getter(EbsVolumeConfiguration::storage)).setter(EbsVolumeConfiguration.setter(Builder::storage)).constructor(StorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()}).build();
    private static final SdkField<BlockStoragePerformanceConfiguration> PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performance").getter(EbsVolumeConfiguration.getter(EbsVolumeConfiguration::performance)).setter(EbsVolumeConfiguration.setter(Builder::performance)).constructor(BlockStoragePerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performance").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentState").getter(EbsVolumeConfiguration.getter(EbsVolumeConfiguration::attachmentState)).setter(EbsVolumeConfiguration.setter(Builder::attachmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_FIELD, PERFORMANCE_FIELD, ATTACHMENT_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final StorageConfiguration storage;
    private final BlockStoragePerformanceConfiguration performance;
    private final String attachmentState;

    private EbsVolumeConfiguration(BuilderImpl builder) {
        this.storage = builder.storage;
        this.performance = builder.performance;
        this.attachmentState = builder.attachmentState;
    }

    public final StorageConfiguration storage() {
        return this.storage;
    }

    public final BlockStoragePerformanceConfiguration performance() {
        return this.performance;
    }

    public final String attachmentState() {
        return this.attachmentState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        hashCode = 31 * hashCode + Objects.hashCode(this.performance());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolumeConfiguration)) {
            return false;
        }
        EbsVolumeConfiguration other = (EbsVolumeConfiguration)obj;
        return Objects.equals(this.storage(), other.storage()) && Objects.equals(this.performance(), other.performance()) && Objects.equals(this.attachmentState(), other.attachmentState());
    }

    public final String toString() {
        return ToString.builder((String)"EbsVolumeConfiguration").add("Storage", (Object)this.storage()).add("Performance", (Object)this.performance()).add("AttachmentState", (Object)this.attachmentState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
            case "performance": {
                return Optional.ofNullable(clazz.cast(this.performance()));
            }
            case "attachmentState": {
                return Optional.ofNullable(clazz.cast(this.attachmentState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolumeConfiguration, T> g) {
        return obj -> g.apply((EbsVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StorageConfiguration storage;
        private BlockStoragePerformanceConfiguration performance;
        private String attachmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolumeConfiguration model) {
            this.storage(model.storage);
            this.performance(model.performance);
            this.attachmentState(model.attachmentState);
        }

        public final StorageConfiguration.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        public final void setStorage(StorageConfiguration.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(StorageConfiguration storage) {
            this.storage = storage;
            return this;
        }

        public final BlockStoragePerformanceConfiguration.Builder getPerformance() {
            return this.performance != null ? this.performance.toBuilder() : null;
        }

        public final void setPerformance(BlockStoragePerformanceConfiguration.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(BlockStoragePerformanceConfiguration performance) {
            this.performance = performance;
            return this;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        public EbsVolumeConfiguration build() {
            return new EbsVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsVolumeConfiguration> {
        public Builder storage(StorageConfiguration var1);

        default public Builder storage(Consumer<StorageConfiguration.Builder> storage) {
            return this.storage((StorageConfiguration)((StorageConfiguration.Builder)StorageConfiguration.builder().applyMutation(storage)).build());
        }

        public Builder performance(BlockStoragePerformanceConfiguration var1);

        default public Builder performance(Consumer<BlockStoragePerformanceConfiguration.Builder> performance) {
            return this.performance((BlockStoragePerformanceConfiguration)((BlockStoragePerformanceConfiguration.Builder)BlockStoragePerformanceConfiguration.builder().applyMutation(performance)).build());
        }

        public Builder attachmentState(String var1);
    }
}

