/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.AccountIdListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.ActionType;
import software.amazon.awssdk.services.costoptimizationhub.model.ActionTypeListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.ImplementationEffort;
import software.amazon.awssdk.services.costoptimizationhub.model.ImplementationEffortListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.RecommendationIdListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.RegionListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceArnListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceIdListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceType;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.Tag;
import software.amazon.awssdk.services.costoptimizationhub.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(Filter.getter(Filter::accountIds)).setter(Filter.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionTypes").getter(Filter.getter(Filter::actionTypesAsStrings)).setter(Filter.setter(Builder::actionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPLEMENTATION_EFFORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("implementationEfforts").getter(Filter.getter(Filter::implementationEffortsAsStrings)).setter(Filter.setter(Builder::implementationEffortsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("implementationEfforts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(Filter.getter(Filter::recommendationIds)).setter(Filter.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(Filter.getter(Filter::regions)).setter(Filter.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(Filter.getter(Filter::resourceArns)).setter(Filter.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(Filter.getter(Filter::resourceIds)).setter(Filter.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(Filter.getter(Filter::resourceTypesAsStrings)).setter(Filter.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RESTART_NEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("restartNeeded").getter(Filter.getter(Filter::restartNeeded)).setter(Filter.setter(Builder::restartNeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartNeeded").build()}).build();
    private static final SdkField<Boolean> ROLLBACK_POSSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rollbackPossible").getter(Filter.getter(Filter::rollbackPossible)).setter(Filter.setter(Builder::rollbackPossible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackPossible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Filter.getter(Filter::tags)).setter(Filter.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, ACTION_TYPES_FIELD, IMPLEMENTATION_EFFORTS_FIELD, RECOMMENDATION_IDS_FIELD, REGIONS_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_IDS_FIELD, RESOURCE_TYPES_FIELD, RESTART_NEEDED_FIELD, ROLLBACK_POSSIBLE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final List<String> actionTypes;
    private final List<String> implementationEfforts;
    private final List<String> recommendationIds;
    private final List<String> regions;
    private final List<String> resourceArns;
    private final List<String> resourceIds;
    private final List<String> resourceTypes;
    private final Boolean restartNeeded;
    private final Boolean rollbackPossible;
    private final List<Tag> tags;

    private Filter(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.actionTypes = builder.actionTypes;
        this.implementationEfforts = builder.implementationEfforts;
        this.recommendationIds = builder.recommendationIds;
        this.regions = builder.regions;
        this.resourceArns = builder.resourceArns;
        this.resourceIds = builder.resourceIds;
        this.resourceTypes = builder.resourceTypes;
        this.restartNeeded = builder.restartNeeded;
        this.rollbackPossible = builder.rollbackPossible;
        this.tags = builder.tags;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final List<ActionType> actionTypes() {
        return ActionTypeListCopier.copyStringToEnum(this.actionTypes);
    }

    public final boolean hasActionTypes() {
        return this.actionTypes != null && !(this.actionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> actionTypesAsStrings() {
        return this.actionTypes;
    }

    public final List<ImplementationEffort> implementationEfforts() {
        return ImplementationEffortListCopier.copyStringToEnum(this.implementationEfforts);
    }

    public final boolean hasImplementationEfforts() {
        return this.implementationEfforts != null && !(this.implementationEfforts instanceof SdkAutoConstructList);
    }

    public final List<String> implementationEffortsAsStrings() {
        return this.implementationEfforts;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIds() {
        return this.resourceIds;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final Boolean restartNeeded() {
        return this.restartNeeded;
    }

    public final Boolean rollbackPossible() {
        return this.rollbackPossible;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionTypes() ? this.actionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImplementationEfforts() ? this.implementationEffortsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restartNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackPossible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasActionTypes() == other.hasActionTypes() && Objects.equals(this.actionTypesAsStrings(), other.actionTypesAsStrings()) && this.hasImplementationEfforts() == other.hasImplementationEfforts() && Objects.equals(this.implementationEffortsAsStrings(), other.implementationEffortsAsStrings()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.restartNeeded(), other.restartNeeded()) && Objects.equals(this.rollbackPossible(), other.rollbackPossible()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("ActionTypes", this.hasActionTypes() ? this.actionTypesAsStrings() : null).add("ImplementationEfforts", this.hasImplementationEfforts() ? this.implementationEffortsAsStrings() : null).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("Regions", this.hasRegions() ? this.regions() : null).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("RestartNeeded", (Object)this.restartNeeded()).add("RollbackPossible", (Object)this.rollbackPossible()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "actionTypes": {
                return Optional.ofNullable(clazz.cast(this.actionTypesAsStrings()));
            }
            case "implementationEfforts": {
                return Optional.ofNullable(clazz.cast(this.implementationEffortsAsStrings()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "restartNeeded": {
                return Optional.ofNullable(clazz.cast(this.restartNeeded()));
            }
            case "rollbackPossible": {
                return Optional.ofNullable(clazz.cast(this.rollbackPossible()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> actionTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> implementationEfforts = DefaultSdkAutoConstructList.getInstance();
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean restartNeeded;
        private Boolean rollbackPossible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.accountIds(model.accountIds);
            this.actionTypesWithStrings(model.actionTypes);
            this.implementationEffortsWithStrings(model.implementationEfforts);
            this.recommendationIds(model.recommendationIds);
            this.regions(model.regions);
            this.resourceArns(model.resourceArns);
            this.resourceIds(model.resourceIds);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.restartNeeded(model.restartNeeded);
            this.rollbackPossible(model.rollbackPossible);
            this.tags(model.tags);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getActionTypes() {
            if (this.actionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionTypes;
        }

        public final void setActionTypes(Collection<String> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copy(actionTypes);
        }

        @Override
        public final Builder actionTypesWithStrings(Collection<String> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copy(actionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypesWithStrings(String ... actionTypes) {
            this.actionTypesWithStrings(Arrays.asList(actionTypes));
            return this;
        }

        @Override
        public final Builder actionTypes(Collection<ActionType> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copyEnumToString(actionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(ActionType ... actionTypes) {
            this.actionTypes(Arrays.asList(actionTypes));
            return this;
        }

        public final Collection<String> getImplementationEfforts() {
            if (this.implementationEfforts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.implementationEfforts;
        }

        public final void setImplementationEfforts(Collection<String> implementationEfforts) {
            this.implementationEfforts = ImplementationEffortListCopier.copy(implementationEfforts);
        }

        @Override
        public final Builder implementationEffortsWithStrings(Collection<String> implementationEfforts) {
            this.implementationEfforts = ImplementationEffortListCopier.copy(implementationEfforts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder implementationEffortsWithStrings(String ... implementationEfforts) {
            this.implementationEffortsWithStrings(Arrays.asList(implementationEfforts));
            return this;
        }

        @Override
        public final Builder implementationEfforts(Collection<ImplementationEffort> implementationEfforts) {
            this.implementationEfforts = ImplementationEffortListCopier.copyEnumToString(implementationEfforts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder implementationEfforts(ImplementationEffort ... implementationEfforts) {
            this.implementationEfforts(Arrays.asList(implementationEfforts));
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Boolean getRestartNeeded() {
            return this.restartNeeded;
        }

        public final void setRestartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
        }

        @Override
        public final Builder restartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
            return this;
        }

        public final Boolean getRollbackPossible() {
            return this.rollbackPossible;
        }

        public final void setRollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
        }

        @Override
        public final Builder rollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder actionTypesWithStrings(Collection<String> var1);

        public Builder actionTypesWithStrings(String ... var1);

        public Builder actionTypes(Collection<ActionType> var1);

        public Builder actionTypes(ActionType ... var1);

        public Builder implementationEffortsWithStrings(Collection<String> var1);

        public Builder implementationEffortsWithStrings(String ... var1);

        public Builder implementationEfforts(Collection<ImplementationEffort> var1);

        public Builder implementationEfforts(ImplementationEffort ... var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder restartNeeded(Boolean var1);

        public Builder rollbackPossible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

