/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourcePricing;
import software.amazon.awssdk.services.costoptimizationhub.model.Usage;
import software.amazon.awssdk.services.costoptimizationhub.model.UsageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceCostCalculation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceCostCalculation> {
    private static final SdkField<ResourcePricing> PRICING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pricing").getter(ResourceCostCalculation.getter(ResourceCostCalculation::pricing)).setter(ResourceCostCalculation.setter(Builder::pricing)).constructor(ResourcePricing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricing").build()}).build();
    private static final SdkField<List<Usage>> USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usages").getter(ResourceCostCalculation.getter(ResourceCostCalculation::usages)).setter(ResourceCostCalculation.setter(Builder::usages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Usage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_FIELD, USAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourcePricing pricing;
    private final List<Usage> usages;

    private ResourceCostCalculation(BuilderImpl builder) {
        this.pricing = builder.pricing;
        this.usages = builder.usages;
    }

    public final ResourcePricing pricing() {
        return this.pricing;
    }

    public final boolean hasUsages() {
        return this.usages != null && !(this.usages instanceof SdkAutoConstructList);
    }

    public final List<Usage> usages() {
        return this.usages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pricing());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsages() ? this.usages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCostCalculation)) {
            return false;
        }
        ResourceCostCalculation other = (ResourceCostCalculation)obj;
        return Objects.equals(this.pricing(), other.pricing()) && this.hasUsages() == other.hasUsages() && Objects.equals(this.usages(), other.usages());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceCostCalculation").add("Pricing", (Object)this.pricing()).add("Usages", this.hasUsages() ? this.usages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pricing": {
                return Optional.ofNullable(clazz.cast(this.pricing()));
            }
            case "usages": {
                return Optional.ofNullable(clazz.cast(this.usages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCostCalculation, T> g) {
        return obj -> g.apply((ResourceCostCalculation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourcePricing pricing;
        private List<Usage> usages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCostCalculation model) {
            this.pricing(model.pricing);
            this.usages(model.usages);
        }

        public final ResourcePricing.Builder getPricing() {
            return this.pricing != null ? this.pricing.toBuilder() : null;
        }

        public final void setPricing(ResourcePricing.BuilderImpl pricing) {
            this.pricing = pricing != null ? pricing.build() : null;
        }

        @Override
        public final Builder pricing(ResourcePricing pricing) {
            this.pricing = pricing;
            return this;
        }

        public final List<Usage.Builder> getUsages() {
            List<Usage.Builder> result = UsageListCopier.copyToBuilder(this.usages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsages(Collection<Usage.BuilderImpl> usages) {
            this.usages = UsageListCopier.copyFromBuilder(usages);
        }

        @Override
        public final Builder usages(Collection<Usage> usages) {
            this.usages = UsageListCopier.copy(usages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usages(Usage ... usages) {
            this.usages(Arrays.asList(usages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usages(Consumer<Usage.Builder> ... usages) {
            this.usages(Stream.of(usages).map(c -> (Usage)((Usage.Builder)Usage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceCostCalculation build() {
            return new ResourceCostCalculation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceCostCalculation> {
        public Builder pricing(ResourcePricing var1);

        default public Builder pricing(Consumer<ResourcePricing.Builder> pricing) {
            return this.pricing((ResourcePricing)((ResourcePricing.Builder)ResourcePricing.builder().applyMutation(pricing)).build());
        }

        public Builder usages(Collection<Usage> var1);

        public Builder usages(Usage ... var1);

        public Builder usages(Consumer<Usage.Builder> ... var1);
    }
}

