/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.Filter;
import software.amazon.awssdk.services.costoptimizationhub.model.OrderBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationsRequest
extends CostOptimizationHubRequest
implements ToCopyableBuilder<Builder, ListRecommendationsRequest> {
    private static final SdkField<Filter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListRecommendationsRequest.getter(ListRecommendationsRequest::filter)).setter(ListRecommendationsRequest.setter(Builder::filter)).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeAllRecommendations").getter(ListRecommendationsRequest.getter(ListRecommendationsRequest::includeAllRecommendations)).setter(ListRecommendationsRequest.setter(Builder::includeAllRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAllRecommendations").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRecommendationsRequest.getter(ListRecommendationsRequest::maxResults)).setter(ListRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationsRequest.getter(ListRecommendationsRequest::nextToken)).setter(ListRecommendationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<OrderBy> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orderBy").getter(ListRecommendationsRequest.getter(ListRecommendationsRequest::orderBy)).setter(ListRecommendationsRequest.setter(Builder::orderBy)).constructor(OrderBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, INCLUDE_ALL_RECOMMENDATIONS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_FIELD));
    private final Filter filter;
    private final Boolean includeAllRecommendations;
    private final Integer maxResults;
    private final String nextToken;
    private final OrderBy orderBy;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.includeAllRecommendations = builder.includeAllRecommendations;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
    }

    public final Filter filter() {
        return this.filter;
    }

    public final Boolean includeAllRecommendations() {
        return this.includeAllRecommendations;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final OrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllRecommendations());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.includeAllRecommendations(), other.includeAllRecommendations()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderBy(), other.orderBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationsRequest").add("Filter", (Object)this.filter()).add("IncludeAllRecommendations", (Object)this.includeAllRecommendations()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrderBy", (Object)this.orderBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "includeAllRecommendations": {
                return Optional.ofNullable(clazz.cast(this.includeAllRecommendations()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubRequest.BuilderImpl
    implements Builder {
        private Filter filter;
        private Boolean includeAllRecommendations;
        private Integer maxResults;
        private String nextToken;
        private OrderBy orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            this.filter(model.filter);
            this.includeAllRecommendations(model.includeAllRecommendations);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.orderBy(model.orderBy);
        }

        public final Filter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getIncludeAllRecommendations() {
            return this.includeAllRecommendations;
        }

        public final void setIncludeAllRecommendations(Boolean includeAllRecommendations) {
            this.includeAllRecommendations = includeAllRecommendations;
        }

        @Override
        public final Builder includeAllRecommendations(Boolean includeAllRecommendations) {
            this.includeAllRecommendations = includeAllRecommendations;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final OrderBy.Builder getOrderBy() {
            return this.orderBy != null ? this.orderBy.toBuilder() : null;
        }

        public final void setOrderBy(OrderBy.BuilderImpl orderBy) {
            this.orderBy = orderBy != null ? orderBy.build() : null;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostOptimizationHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationsRequest> {
        public Builder filter(Filter var1);

        default public Builder filter(Consumer<Filter.Builder> filter) {
            return this.filter((Filter)((Filter.Builder)Filter.builder().applyMutation(filter)).build());
        }

        public Builder includeAllRecommendations(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder orderBy(OrderBy var1);

        default public Builder orderBy(Consumer<OrderBy.Builder> orderBy) {
            return this.orderBy((OrderBy)((OrderBy.Builder)OrderBy.builder().applyMutation(orderBy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

