/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RightsizingRecommendationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RightsizingRecommendationMetadata> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RightsizingRecommendationMetadata.getter(RightsizingRecommendationMetadata::recommendationId)).setter(RightsizingRecommendationMetadata.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RightsizingRecommendationMetadata.getter(RightsizingRecommendationMetadata::generationTimestamp)).setter(RightsizingRecommendationMetadata.setter(Builder::generationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RightsizingRecommendationMetadata.getter(RightsizingRecommendationMetadata::lookbackPeriodInDaysAsString)).setter(RightsizingRecommendationMetadata.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, GENERATION_TIMESTAMP_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationId;
    private final String generationTimestamp;
    private final String lookbackPeriodInDays;

    private RightsizingRecommendationMetadata(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationTimestamp = builder.generationTimestamp;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
    }

    public String recommendationId() {
        return this.recommendationId;
    }

    public String generationTimestamp() {
        return this.generationTimestamp;
    }

    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationMetadata)) {
            return false;
        }
        RightsizingRecommendationMetadata other = (RightsizingRecommendationMetadata)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.generationTimestamp(), other.generationTimestamp()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString());
    }

    public String toString() {
        return ToString.builder((String)"RightsizingRecommendationMetadata").add("RecommendationId", (Object)this.recommendationId()).add("GenerationTimestamp", (Object)this.generationTimestamp()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "GenerationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.generationTimestamp()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationMetadata, T> g) {
        return obj -> g.apply((RightsizingRecommendationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private String generationTimestamp;
        private String lookbackPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationMetadata model) {
            this.recommendationId(model.recommendationId);
            this.generationTimestamp(model.generationTimestamp);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final String getGenerationTimestamp() {
            return this.generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        public final String getLookbackPeriodInDaysAsString() {
            return this.lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public RightsizingRecommendationMetadata build() {
            return new RightsizingRecommendationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RightsizingRecommendationMetadata> {
        public Builder recommendationId(String var1);

        public Builder generationTimestamp(String var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);
    }
}

