/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSInstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::family)).setter(RDSInstanceDetails.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::instanceType)).setter(RDSInstanceDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::region)).setter(RDSInstanceDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> DATABASE_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::databaseEngine)).setter(RDSInstanceDetails.setter(Builder::databaseEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseEngine").build()}).build();
    private static final SdkField<String> DATABASE_EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::databaseEdition)).setter(RDSInstanceDetails.setter(Builder::databaseEdition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseEdition").build()}).build();
    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::deploymentOption)).setter(RDSInstanceDetails.setter(Builder::deploymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentOption").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RDSInstanceDetails.getter(RDSInstanceDetails::licenseModel)).setter(RDSInstanceDetails.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RDSInstanceDetails.getter(RDSInstanceDetails::currentGeneration)).setter(RDSInstanceDetails.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()}).build();
    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RDSInstanceDetails.getter(RDSInstanceDetails::sizeFlexEligible)).setter(RDSInstanceDetails.setter(Builder::sizeFlexEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, INSTANCE_TYPE_FIELD, REGION_FIELD, DATABASE_ENGINE_FIELD, DATABASE_EDITION_FIELD, DEPLOYMENT_OPTION_FIELD, LICENSE_MODEL_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String family;
    private final String instanceType;
    private final String region;
    private final String databaseEngine;
    private final String databaseEdition;
    private final String deploymentOption;
    private final String licenseModel;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private RDSInstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.instanceType = builder.instanceType;
        this.region = builder.region;
        this.databaseEngine = builder.databaseEngine;
        this.databaseEdition = builder.databaseEdition;
        this.deploymentOption = builder.deploymentOption;
        this.licenseModel = builder.licenseModel;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public String family() {
        return this.family;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String region() {
        return this.region;
    }

    public String databaseEngine() {
        return this.databaseEngine;
    }

    public String databaseEdition() {
        return this.databaseEdition;
    }

    public String deploymentOption() {
        return this.deploymentOption;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseEdition());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSInstanceDetails)) {
            return false;
        }
        RDSInstanceDetails other = (RDSInstanceDetails)obj;
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.databaseEngine(), other.databaseEngine()) && Objects.equals(this.databaseEdition(), other.databaseEdition()) && Objects.equals(this.deploymentOption(), other.deploymentOption()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public String toString() {
        return ToString.builder((String)"RDSInstanceDetails").add("Family", (Object)this.family()).add("InstanceType", (Object)this.instanceType()).add("Region", (Object)this.region()).add("DatabaseEngine", (Object)this.databaseEngine()).add("DatabaseEdition", (Object)this.databaseEdition()).add("DeploymentOption", (Object)this.deploymentOption()).add("LicenseModel", (Object)this.licenseModel()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "DatabaseEngine": {
                return Optional.ofNullable(clazz.cast(this.databaseEngine()));
            }
            case "DatabaseEdition": {
                return Optional.ofNullable(clazz.cast(this.databaseEdition()));
            }
            case "DeploymentOption": {
                return Optional.ofNullable(clazz.cast(this.deploymentOption()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSInstanceDetails, T> g) {
        return obj -> g.apply((RDSInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String family;
        private String instanceType;
        private String region;
        private String databaseEngine;
        private String databaseEdition;
        private String deploymentOption;
        private String licenseModel;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSInstanceDetails model) {
            this.family(model.family);
            this.instanceType(model.instanceType);
            this.region(model.region);
            this.databaseEngine(model.databaseEngine);
            this.databaseEdition(model.databaseEdition);
            this.deploymentOption(model.deploymentOption);
            this.licenseModel(model.licenseModel);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return this.family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDatabaseEngine() {
            return this.databaseEngine;
        }

        @Override
        public final Builder databaseEngine(String databaseEngine) {
            this.databaseEngine = databaseEngine;
            return this;
        }

        public final void setDatabaseEngine(String databaseEngine) {
            this.databaseEngine = databaseEngine;
        }

        public final String getDatabaseEdition() {
            return this.databaseEdition;
        }

        @Override
        public final Builder databaseEdition(String databaseEdition) {
            this.databaseEdition = databaseEdition;
            return this;
        }

        public final void setDatabaseEdition(String databaseEdition) {
            this.databaseEdition = databaseEdition;
        }

        public final String getDeploymentOption() {
            return this.deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        public RDSInstanceDetails build() {
            return new RDSInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSInstanceDetails> {
        public Builder family(String var1);

        public Builder instanceType(String var1);

        public Builder region(String var1);

        public Builder databaseEngine(String var1);

        public Builder databaseEdition(String var1);

        public Builder deploymentOption(String var1);

        public Builder licenseModel(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

